<?php
namespace addons\cerp;	// 注意命名空间规范

use addons\cerp\lib\queue\QueueOrder;
use app\b2c\model\Order;
use app\common\Addons;

/**
 * 管易CERP对接插件
 */
class Addon extends Addons
{
    public $code = "cerp";               //插件标识  必须与文件夹名完全一样
    public $name = "管易CERP对接插件";               //插件名称
    public $description = "通过此插件，和管易cerp插件进行对接";        //插件描述
    public $author = "SIN";             //作者
    public $version = "V1.0.0";            //版本
    public $relyon = [                  //依赖，安装此插件需要满足的条件，那些应用和插件必须先安装
        'app' => [],
        'addons' => []
    ];


    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        
        return recode(10000);
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        return recode(10000);
    }

    //订单创建成功事件
    public function b2cOrderPaySuccess(Order $info){
        $lib = new QueueOrder();
        $re = $lib->add($info['order_id']);
        //::todo  如果异常，可以做异常处理
        return true;
    }

    
    /**
     * 应用初始化
     */
    public function init()
    {
        return recode(10000);
    }


}