<?php
namespace addons\cerp\controller\manage;

use addons\tplmanage\model\Menu;
use app\base\model\Manage;
use app\base\model\RoleApi;
use app\common\ManageApi;

class Task extends ManageApi
{
    /**
     * 菜单
     */
    public function menu()
    {
        $where = [];
        if(!in_array($this->manage_id, config('shop.base.superManage'))){
            $api = $this->manageApi();
            if(!$api){
                return recode(10101);
            }
            $where[] = ['manageapi', 'in', $api];
        }
        
        $m = new Menu();
        $list = $m->where($where)->order('sort', 'asc')->select()->toArray();
        $tree = [];
        $this->createMenu($tree, $list);
        return recode(10000, $tree);
    }

    /**
     * 获取当前用户的所有接口权限
     */
    private function manageApi(){
        $manageModel = new Manage();
        $info = $manageModel->where('id', $this->manage_id)->find();
        if(!$info){
            return [];
        }
        //查找所有有权限的接口
        $raModel = new RoleApi();
        $raWhere[] = ['role_id', 'in', $info['role_id']];
        $apiList = $raModel->where($raWhere)->column('api');

        return $apiList;
    }

    //构建菜单树
    private function createMenu(&$tree, &$list, $pid = 0){
        foreach($list as $v){
            if($v['pid'] == $pid){
                $children = [];
                $this->createmenu($children, $list, $v['id']);
                $tree[] = [
                    'id' => $v['id'],
                    'path' => $v['path'],
                    'name' => $v['name'],
                    'icon' => $v['icon'],
                    'children' => $children
                ];
            }
        }
        return true;
    }

}