<?php

namespace addons\cerp\lib;

use app\common\addons\AddonsLib;

/**
 * 请求
 */
class Post extends AddonsLib
{
    //cerp接口加密并请求
    public static function send($data){
        $config = config('addons.cerp');

        $data['appkey'] = $config['appKey'];
        $data['sessionkey'] = $config['sessionKey'];
        
        //签名
        $sign         = self::sign($data, $config['secret']);
        $data['sign'] = $sign;

        //file_put_contents("./cerp.txt", date("Y-m-d H:i:s")."\r\n".var_export($data,true)."\r\n",FILE_APPEND);

        //发送
        $re = self::curl($config['url'], $data);
        $re = json_decode($re, true);
        if($re['success'] !== true){
            $msg = isset($re['errorCode'])?($re['errorCode'].":"):"";
            $msg = $msg . isset($re['errorDesk'])?($re['errorDesc']):"";
            if($msg == ""){
                $msg = "出错了。";
            }
            return recode(10100, $re, $msg);
        }
        return recode(10000, $re);
    }

    public static function curl($url, $data)
    {
        $data_string = self::json_encode_ch($data);
        $ch          = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type:text/json;charset=utf-8',
            'Content-Length:' . strlen($data_string)
        ]);
        $content = curl_exec($ch);
        curl_close($ch);
        return $content;
    }

    /**
     * 签名
     * @param $data
     * @param $secret
     * @return string
     */
    static function sign($data, $secret)
    {
        if (empty($data)) {
            return "";
        }
        unset($data['sign']); //可选，具体看传参
        $data = self::json_encode_ch($data);
        $sign = strtoupper(md5($secret . $data . $secret));
        return $sign;
    }


    /**
     * 汉字转换
     * @param $arr
     * @return string
     */
    static function json_encode_ch($arr)
    {
        return urldecode(json_encode(self::url_encode_arr($arr)));
    }
    
    /**
     * URL转换
     * @param $arr
     * @return array|string
     */
    static function url_encode_arr($arr)
    {
        if (is_array($arr)) {
            foreach ($arr as $k => $v) {
                $arr[$k] = self::url_encode_arr($v);
            }
        } else if (!is_numeric($arr) && !is_bool($arr)) {
            $arr = urlencode($arr);
        }
        return $arr;
    }

    //特殊字符替换
    public static function replaceChar($str){
        if(is_null($str)){
            return "";
        }
        $character = ["\r\n", "\n", "\r", "+"];
        $str = str_replace(PHP_EOL, '', $str);
        return str_replace($character, '', $str);
    }
    

}