<?php
//库存
namespace addons\cerp\lib\api;

use addons\cerp\lib\Post;
use app\common\addons\AddonsLib;

class GyErpNewStockGet extends AddonsLib
{
    const method = 'gy.erp.new.stock.get'; 

    public static function api($data){
        if(!isset($data['start_date'])){
            return recode(10100, [], '修改时间开始段必填');
        }
        if(!isset($data['end_date'])){
            return recode(10100, [], '修改时间结束段必填');
        }
        if(($data['end_date'] - $data['start_date']) > 60*60*24*1){       //如果开始时间和结束时间超过1天，那结束时间就从开始时间往后推1天
            return recode(10100, [], '修改时间段不能大于1天');
        }

        $data['method'] = self::method;

        return Post::send($data);


    }
}
