<?php
namespace addons\cerp\lib\api;

use addons\cerp\lib\Post;
use app\b2c\model\Aftersales;
use app\b2c\model\Order;
use app\b2c\model\OrderItems;
use app\base\model\Addons;
use app\base\model\Area;
use app\base\model\Payments;
use app\base\model\User;
use app\common\addons\AddonsLib;

class GyErpTradeAdd extends AddonsLib
{
    const method = 'gy.erp.trade.add'; 

    public static function api($order_id){
        
        $orderModel = new Order();
        $order = $orderModel->where('order_id', $order_id)->find();
        if(!$order){
            return recode(10100, '', "订单未找到");
        }
        if($order['pay_status'] == 1){
            return recode(10100, '', '订单未支付');
        }
        // 查询这个订单有没有售后，售后待审核的状态下不能推送，审核拒绝再推送
        $billAftersales = new Aftersales();
        $where2 = [
            ['order_id', '=', $order_id],
            ['status', '=', 1]
        ];
        if($billAftersales->where($where2)->find()){
            return recode(10100, '', '存在活动中的售后，请先处理售后问题');
        }

        //收货地址特殊字符替换
        $order['ship_address'] = Post::replaceChar($order['ship_address']);

        $address = Area::getFullName($order['ship_area_code']);
        $address_arr = explode(" ", $address);
        //校验address是否正确
        if(count($address_arr) < 3){
            return recode(10100, '', "地区编码：".$order['ship_area_code']."没有找到省市区信息");
        }
        //组装订单数据

        $params        = [
            'method'            => self::method,
            'shop_code'         => config('addons.cerp.shopCode'), //店铺代码
            'vip_code'          => Post::replaceChar(User::showFieldById($order['user_id'])),//用户昵称
            'platform_code'     => $order['order_id'], //平台单号
            'seller_memo'       => Post::replaceChar($order['mark']),
            //'cod'               => false, //是否货到付款
            'deal_datetime'     => $order['pay_time'],
            'order_type_code'   => "Sales", //订单类型
            'buyer_memo'        => Post::replaceChar($order['memo']),
            'receiver_name'     => $order['ship_name'],
            'receiver_phone'    => $order['ship_mobile'],
            'receiver_mobile'   => $order['ship_mobile'],
            'receiver_province' => $address_arr[0],
            'receiver_city' => $address_arr[1],
            'receiver_district' => $address_arr[2],
            'receiver_address'  =>$address.$order['ship_address']
        ];

        //组装商品明细
        $re_details = self::getItems($order['order_id']);
        if($re_details['code'] >= 10100){
            return $re_details;
        }
        $params['details'] = $re_details['data'];

        //取支付单信息
        $re_payments = self::getPaymentInfo($order['order_id']);
        if($re_payments['code'] >= 10100){
            return $re_payments;
        }
        if($re_payments['data']){
            $params['payments'] = $re_payments['data'];
        }
         
        $params['method'] = self::method;

        return Post::send($params);
    }

    //取订单明细数据
    private static function getItems($order_id){
        $details = [];
        //$aftersalesList = $this->getAftersalesItems($order_id);
        $m = new OrderItems();
        $list = $m->where('order_id', $order_id)->select();
        foreach ($list as $v) {
            //如果有售后数量，要减掉
            // if(isset($aftersalesList[$v['id']])){
            //     $v['nums'] -= $aftersalesList[$v['id']];
            // }

            //判断数量是否等于0,就跳过，可能是售后退掉了
            // if($v['nums'] <= 0){
            //     continue;
            //     // $result['msg'] = "商品数量不能等于0";
            //     // return $result;
            // }
            $details[] = [
                'oid'          => $v['id'],
                'item_code'    => $v['pcode'],
                'price'        => $v['real_amount']/$v['nums'],//商品单价
                'qty'          => $v['nums']
            ];
        }

        if(!$details){
            return recode(10100, '', '没有待发货的订单明细');
        }

        return recode(10000, $details);
    }

    //推送订单的时候，组装订单的支付单信息
    private static function getPaymentInfo($order_id){
        $config = Addons::getAddon('cerp')->getConfigFile();
        $data = [];
        //组装支付明细
        //组装支付单
        $m = new Payments();

        $bprWhere = [
            ['source_ids', 'find in set', $order_id],
            ['status', '=', 2],
            ['type', '=', 'order']
        ];
        $bpList = $m->where($bprWhere)->select();        

        foreach ($bpList as $v) {
            if(!isset($config['payments'][$v['payment_code']])){
                return recode(10100, '', '请现在config文件中维护支付方式对应信息');
            }
            
            $data[] = [
                'pay_type_code' => $config['payments'][$v['payment_code']], //支付类型代码
                'payment'       => $v['money'], //订单金额
            ];
        }

        return recode(10000, $data);
    }


}
