<?php

namespace addons\cerp\lib\queue;

use addons\cerp\model\Queue;
use app\b2c\model\Delivery;
use app\base\model\Addons;

/**
 * 请求
 */
class QueueDeliverys extends BaseQueue
{

    const TYPE = 1;

    public static function exec(Queue $queue){
        $queue->nums += 1;
        
        $params = json_decode($queue['params'], true);

        //如果值不对，直接设置为执行失败，返回
        if(!$params || !isset($params['details'])){
            $queue->status = 4;
            $queue->remsg = "数据格式有误";
            $queue->save();
            return recode(10100, '', '数据格式有误');
        }

        //取配置文件里的物流公司对照表
        $config = Addons::getAddon('cerp')->getConfigFile();
        if(!isset($config['express_code'][$params['express_code']])){
            $queue->status = 4;
            $queue->remsg = "cerp物流编码:".$params['express_code']."没有维护到配置文件里的对照表里";
            $queue->save();
            return recode(10100, '', "cerp物流编码:".$params['express_code']."没有维护到配置文件里的对照表里");
        }

        $deliveryModel = new Delivery();
        $data = [
            'delivery_id' => $params['code'],
            'order_ids' => str_replace(";",",",$params['platform_code']),
            'logi_no' => $config['express_code'][$params['express_code']],
            'logi_code' => $params['express_no'],
            'warehouse_code' => $params['warehouse_code']
        ];
        $items  = [];
        foreach ($params['details'] as $k => $v) {
            $items[$v['sku_code']] = $v['qty'];
        }

        $re = $deliveryModel->ship($data, $items);
        if($re['code'] >= 10100){
            $queue->status = 4;
        }else{
            $queue->status = 3;
        }
        $queue->remsg = $re['msg'];

        $queue->save();
        return $re;
    }

}