<?php
namespace addons\cerp\lib\task;

use addons\cerp\model\Task;
use app\common\addons\AddonsLib;
/**
 * 
 */
class BaseTask extends AddonsLib
{
    //添加计划
    protected static function addTask($type, $params, $stime, $etime, $status = 2){
        $m = new Task();
        $re = $m->save([
            'type' => $type,
            'status' => $status,
            'params' => json_encode($params, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
            'stime' => $stime,
            'etime' => $etime
        ]);
        if($re){
            return recode(10000, $m->id);
        }else{
            return recode(10100);
        }
    }

    //获取最后执行的时间节点
    public static function lastEtime($type){
        $data = date('Y-m-d H:i:s', time() - 60*60*24*7);        //默认7天前 
        $where = [
            ['type', '=', $type]
        ];
        $m = new Task();
        $info = $m->where($where)->order('id desc')->find();
        if($info){
            $data = $info['etime'];
            $data = date('Y-m-d H:i:s',strtotime($data)+1);
        }
        return $data;
    }
}