<?php
namespace addons\cerp\lib\task;

use addons\cerp\lib\api\GyErpTradeDeliverysGet;
use addons\cerp\lib\queue\QueueDeliverys;
use addons\cerp\model\Queue;
use addons\cerp\model\Task;
/**
 * 
 */
class TaskDeliverys extends BaseTask
{
    const TYPE = 1;
    
    public static function add(){
        $lastTime = self::lastEtime(self::TYPE);

        $data['start_delivery_date'] = $lastTime;          //可能需要加1秒钟
        $data['end_delivery_date']   = date('Y-m-d H:i:s', time()); //请求截至时间
        $data['delivery']            = 1; //发货成功
        
        // if(($data['end_delivery_date'] - $data['start_delivery_date']) > 60*60*24*1){       //如果开始时间和结束时间超过1天，那结束时间就从开始时间往后推1天
        //     $data['end_delivery_date'] = $data['start_delivery_date'] + 60*60*24*1;
        // }
        $re = self::addTask(self::TYPE, $data,$data['start_delivery_date'], $data['end_delivery_date'], 2);
        if($re['code'] >= 10100){
            return $re;
        }

        $taskModel = new Task();
        //去执行
        $re_api = GyErpTradeDeliverysGet::api($data);        
        if($re_api['code'] >= 10100){
            //更新计划
            $taskModel->update([
                'status' => 4,
                'redata' => json_encode($re_api['data'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
                'remsg' => $re_api['msg']
            ],['id' => $re['data']]);
            return $re_api;
        }

        //解析结果，并加到队列
        $re_queue = self::addQueue($re_api['data']);
        if($re_queue['code'] >= 10100){
            $status = 4;
        }else{
            $status = 3;
        }
        //更新计划
        $taskModel->update([
            'status' => $status,
            'redata' => json_encode($re_api['data'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
            'remsg' => $re_queue['msg']
        ],['id' => $re['data']]);
        
        return $re_api;
    }

    private static function addQueue($data){
        if(!isset($data['deliverys'])){
            return recode(10100, [], 'tradeReturns字段不存在.');
        }
        
        $qdata = [];
        foreach ($data['deliverys'] as $val) {
            
            $qdata[] = [
                'external_id' => $val['platform_code'],
                'type' => QueueDeliverys::TYPE,
                'params' => json_encode($val,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
            ];
        }

        if(count($qdata) <= 0){
            return recode(10000, [], '暂无数据.');
        }

        $queueModel = new Queue();
        $queueModel->saveAll($qdata);


        // $num = 0;
        // foreach ($data['deliverys'] as $val) {
        //     $sqlQuery = "INSERT INTO `".config('database.prefix')."erppro_queue` ( `external_id`, `type`, `status`, `params`,`ucode`,`ctime`,`utime`)
        //     SELECT '".$val['platform_code']."', '".$this->type."', '1', '".json_encode($val)."', '".$val['code']."',".time().",".time()."  FROM DUAL
        //     WHERE NOT EXISTS ( SELECT id FROM `".config('database.prefix')."erppro_queue` WHERE `type` = ".$this->type." and `external_id` = '".$val['platform_code']."' and `ucode` = '".$val['code']."')";
        //     $ikey =Db::execute($sqlQuery);
        //     if($ikey){
        //         $num++;
        //     }
        // }

        return recode(10000, [], "更新成功".count($qdata)."条");
    }

}