<?php
namespace addons\dbassistant;	// 注意命名空间规范

use app\common\Addons;

/**
 * 数据库助手插件
 */
class Addon extends Addons
{
    public $code = "dbassistant";               //插件标识  必须与文件夹名完全一样
    public $name = "数据库助手插件";               //插件名称
    public $description = "可备份指定表的结构、数据，可定时的执行备份、还原数据操作等";        //插件描述
    public $author = "SIN";             //作者
    public $version = "V1.0.0";            //版本
    public $relyon = [                  //依赖，安装此插件需要满足的条件，那些应用和插件必须先安装
        'app' => [],
        'addons' => []
    ];


    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'install.sql';
        if(file_exists($file)){
            $sql = file_get_contents($file);
            $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
            $list = explode(';', $sql);
            for ($i = 0; $i < count($list); $i++) {
                if (trim($list[$i])) {
                    \think\facade\Db::execute(trim($list[$i]));
                }
            }
        }

        return recode(10000);
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'uninstall.sql';
        if(file_exists($file)){
            $sql = file_get_contents($file);
            $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
            $list = explode(';', $sql);
            for ($i = 0; $i < count($list); $i++) {
                if (trim($list[$i])) {
                    \think\facade\Db::execute(trim($list[$i]));
                }
            }
        }
        
        return recode(10000);
    }

    /**
     * 应用初始化
     */
    public function init()
    {
        return recode(10000);
    }

    /**
     * 配置信息传到接口端
     */
    public function baseManageConfCommon($conf)
    {
        $conf->addons['dbassistant'] = [
            'backups' => [
                'status' => [
                    1 => '待执行',
                    2 => '执行中',
                    3 => '成功',
                    4 => '失败'
                ],
                'source' => [
                    1 => '手动创建',
                    2 => '定时脚本自动创建',
                ]
            ],
            'tasks' => [
                'status' => [
                    1 => '启用',
                    2 => '停用',
                ],
                'type' => [
                    1 => '定时备份',
                    2 => '定时还原',
                    3 => '定时删除日志',
                ]
            ],
            
        ];
    }



}