<?php
namespace addons\dbassistant\controller\manage;

use addons\dbassistant\model\Backups as ModelBackups;
use app\common\addons\controller\AddonsManageApi;
use think\facade\Db;

class Backups extends AddonsManageApi
{
    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','show'=>true],
                ['label' => 'title', 'prop' => 'title', 'show'=>true],
                ['label' => 'status', 'prop' => 'status', 'show'=>true],
                ['label' => 'dbassistant.code', 'prop' => 'code', 'show'=>true],
                ['label' => 'dbassistant.remsg', 'prop' => 'remsg', 'show'=>true],
                ['label' => 'dbassistant.source', 'prop' => 'source', 'show'=>true],
                ['label' => 'dbassistant.size', 'prop' => 'size', 'show'=>true],
                ['label' => 'ctime', 'prop' => 'ctime', 'show'=>true],
                ['label' => 'utime', 'prop' => 'utime', 'show'=>true],
                ['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 列表
     */
    public function table()
    {
        $page = input('param.page/d', 1);
        $limit = input('param.limit/d', 10);
        $order = input('param.order/a', ['id' => 'desc']);
        $where = $this->tableWhere(input('param.filter/a',[]));
        $type = input('param.type/s','list');
    
        $m = new ModelBackups();
        $data = [];
        if($type == 'list'){
            $field = "*";
            $data['list'] = $m->field($field)->where($where)->page($page, $limit)->order($order)->select();
            
            if(input('?param.fields')){
                $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'dbassistant-Backups-table');
            }
        }elseif($type == 'count'){
            $data['count'] = $m->where($where)->count();
        }
        
        return recode(10000, $data);
    }

    public function add(){
        $m = new ModelBackups();
        return $m->toAdd(
            input('param.title/s', ''),
            input('param.conf/a', []),
            1
        );
    }

    public function del(){
        $m = new ModelBackups();
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => ['id', 'require'],
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        return $m->toDel(input('param.id/d'));
    }

    public function dbtables(){
        $prefix = config('database.connections.mysql.prefix');
        $api = [        //这些表不备份
            $prefix.'addons_dbassistant_backups',
            $prefix.'base_queue',
            $prefix.'addons_dbassistant_tasks',
        ];
        return recode(
            10000,
            array_values(array_diff(array_map(function($v){foreach($v as $vv)return $vv;}, Db::query("show tables")), $api))
        );
    }

    //导入
    public function import(){
        $m = new ModelBackups();
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => ['id', 'require'],
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        return $m->toimport(input('param.id/d'));
    }



    

    /**
     * where条件整理
     */
    private function tableWhere($filter)
    {
        $where = [];

        return $where;
    }
}