<?php
namespace addons\dbassistant\controller\manage;

use addons\dbassistant\model\Backups as ModelBackups;
use addons\dbassistant\model\Tasks as ModelTasks;
use app\common\addons\controller\AddonsManageApi;

class Tasks extends AddonsManageApi
{
    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','show'=>true],
                ['label' => 'title', 'prop' => 'title', 'show'=>true],
                ['label' => 'status', 'prop' => 'status', 'show'=>true],
                ['label' => 'dbassistant.cycle', 'prop' => 'cycle', 'show'=>true],
                ['label' => 'type', 'prop' => 'type', 'show'=>true],
                ['label' => 'ctime', 'prop' => 'ctime', 'show'=>true],
                ['label' => 'utime', 'prop' => 'utime', 'show'=>true],
                ['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 列表
     */
    public function table()
    {
        $page = input('param.page/d', 1);
        $limit = input('param.limit/d', 10);
        $order = input('param.order/a', ['id' => 'desc']);
        $where = $this->tableWhere(input('param.filter/a',[]));
        $type = input('param.type/s','list');
    
        $m = new ModelTasks();
        $data = [];
        if($type == 'list'){
            $field = "*";
            $data['list'] = $m->field($field)->where($where)->page($page, $limit)->order($order)->select();
            
            if(input('?param.fields')){
                $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'dbassistant-Tasks-table');
            }
        }elseif($type == 'count'){
            $data['count'] = $m->where($where)->count();
        }
        
        return recode(10000, $data);
    }

    public function info()
    {
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => recode(10106,'',['id'])
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        $m = new ModelTasks();

        $field = "*";
        $data = $m->field($field)->where('id', input('param.id/s'))->find();
        if(!$data){
            return recode(10107);
        }
        $data['params'] = json_decode($data['params'], true);
        return recode(10000, $data);
    }

    /**
     * 新增&编辑
     */
    public function edit()
    {
        $m = new ModelTasks();
        $data = input('param.');
        unset($data['method']);
        unset($data['token']);
        if(input('?param.id')){
            return $m->toEdit(input('param.id/d'),$data);
        }else{
            return $m->toAdd($data);
        }
    }

    public function del(){
        $m = new ModelTasks();
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => ['id', 'require'],
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        return $m->toDel(input('param.id/d'));
    }

    //手动执行
    public function run(){
        $m = new ModelTasks();
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => ['id', 'require'],
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }

        $info = $m->where('id', input('param.id/d'))->find();
        if(!$info){
            return recode(10107);
        }
        
        return $m->runOne($info);
    }

    /**
     * where条件整理
     */
    private function tableWhere($filter)
    {
        $where = [];

        return $where;
    }
}