<?php
namespace addons\dbassistant\model;

use addons\dbassistant\lib\Dbackup;
use app\common\addons\AddonsModel;
use app\base\model\Queue;

class Backups extends AddonsModel
{
    protected $autoWriteTimestamp = 'timestamp';
    protected $createTime = 'ctime';
    protected $updateTime = 'utime';

    /**
     * 创建备份
     */
    public function toAdd($title, $conf, $source=1){
        if(count($conf) <= 0){
            return recode(10100, '', '请选择数据');
        }
        $data = [
            'title' => $title,
            'status' => 1,
            'code' => date('ymdHis'),
            'source' => $source,
            'size' => '',
            'conf' => json_encode($conf)
        ];
        if(!$this->save($data)){
            return recode(10102);
        }

        $queue_id = Queue::push(self::class, "toExec", $this->id);
        
        return recode(10000,'', '任务已经加到执行队列');
    }

    //删除
    public function toDel($id){
        $info = $this->where('id', $id)->find();
        if(!$info){
            return recode(10104);
        }
        if($info['status'] != 3 && $info['status'] != 4){
            return recode(10104, '', '导出任务进行中，请勿删除');
        }

        //删除文件
        $lib = new Dbackup();
        $lib->delBackup($info['code']);

        if($info->delete()){
            return recode(10004);
        }else{
            return recode(10104);
        }
    }

    //导入
    public function toImport($id){
        $info = $this->where('id', $id)->where('status', 3)->find();
        if(!$info){
            return recode(10100, '', '没有找到该备份，或状态不对，请确认！');
        }

        $queue_id = Queue::push(Dbackup::class, "import", $info['code']);

        return recode(10001, '', '任务已经加到队列中，稍后在系统日志里查看导入结果');
    }

    //执行备份任务
    public function toExec($id){
        $info = $this->where('id',$id)->where('status', 1)->find();
        if(!$info){
            echo '没有找到待执行的数据\n';
            return true;
        }
        $info->status = 2;
        $info->save();

        $tables = json_decode($info['conf'], true);

        $config = [
            'path' => $info['code'],
            'size_limit' => 1024*1024*20
        ];

        $lib = new Dbackup();
        $re = $lib->backup($tables, $config);
        if($re['code'] < 10100){
            $info->status = 3;
            $info->remsg = $re['msg'];
            $info->size = round($re['data']['allsize']/(1024*1024), 2)."M";
        }else{
            $info->status = 4;
            $info->remsg = $re['msg'];
        }
        $info->save();

        return true;
    }



}