<?php
namespace addons\dbassistant\model;

use app\common\addons\AddonsModel;
use think\facade\Validate;

class Tasks extends AddonsModel
{
    protected $autoWriteTimestamp = 'timestamp';
    protected $createTime = 'ctime';
    protected $updateTime = 'utime';
    
    //校验规则
    protected $rule = [
        'title' => 'require',
        'type' => 'integer|in:1,2,3',
        'cycle' => 'require',
        'params' => 'require',
        'status' => 'in:1,2'
    ];
    //校验规则消息
    protected $message = [
        'title.require' => ['title', 'require'],
        'type' => ['type', 'require'],
        'cycle' => ['cycle', 'require'],
        'params' => ['params', 'require'],
        'status' => ['status', 'in:1,2'],
    ];
    //允许添加的字段
    protected $addAllowField = ['title','type','cycle','params', 'status'];
    //允许编辑的字段
    protected $editAllowField = ['title','cycle', 'status'];

    /**
     * 添加
     */
    public function toAdd($data)
    {
        $validate = Validate::rule($this->rule)->message($this->message);
        if(!$validate->check($data)){
            return recode(20000,'',veri($validate->getError()));
        }
        $data['params'] = json_encode($data['params']);
        
        if($this->allowField($this->addAllowField)->save($data))
        {
            return recode(10002,$this->id);
        }else{
            return recode(10102);
        }
    }

    /**
     * 编辑
     */
    public function toEdit($id, $data)
    {   
        if($this->update($data,['id'=> $id],$this->editAllowField))
        {

            return recode(10003);
        }else{
            return recode(10103);
        }
    }

    //按照时间顺序执行计划任务
    public function run(){
        $result = [
            'code' => 10000,
            'data' => [
                'success' => 0,
                'fail' => 0
            ],
            'msg' => ''
        ];
        $nows = self::getRunCycle();
        $list = $this->where('status', 1)->select();
        foreach($list as $v){
            if(in_array($v['cycle'], $nows)){
                $re = $this->runOne($v);
                if($re['code'] < 10100){
                    $result['data']['success']++;
                }else{
                    $result['data']['success']++;
                }
            }
        }
        if($result['data']['success'] == 0 && $result['data']['fail'] == 0){
            $result['msg'] .= "暂无任务执行";
        }else{
            if($result['data']['success'] > 0){
                $result['msg'] .= "执行成功".$result['data']['success']."条记录 ";
            }
            if($result['data']['fail'] > 0){
                $result['msg'] .= "执行失败".$result['data']['fail']."条记录 ";
            }
        }
        return $result;
    }

    //执行某一个计划任务
    public function runOne(Tasks $info){
        $params = json_decode($info['params'],true);
        switch($info['type']){
            case 1:
                $m = new Backups();
                $re = $m->toAdd(
                    "计划任务".$info['id']."创建",
                    $params['conf'],
                    2
                );
                break;
            case 2:
                $m = new Backups();
                $re = $m->toImport($params['id']);
                break;
            case 3:
                $re = $this->clearBackups($params['day']);
                break;

            default:
                $re = recode(10101);
        }

        $info->utime = date('Y-m-d H:i:s');
        $info->save();
        return $re;
    }

    //清除多久之前的自动备份
    private function clearBackups($day = 30){
        $day = abs(intval($day));

        $where = [
            ['source', '=', 2],
            ['ctime', '<', date('Y-m-d H:i:s', time() - $day*60*60*24)]
        ];

        $m = new Backups();
        $list = $m->where($where)->limit(10)->select();
        foreach($list as $v){
            $m->toDel($v['id']);
        }

        return recode(10001);

    }

    //获取需要运行的周期
    private static function getRunCycle(){
        $time = time();
        $sys_crond_timer = [
            '*', '*:i', 'H:i', '@-w H:i', '*-d H:i', 'm-d H:i', 'Y-m-d H:i'
        ];
        $nows = [];
        foreach ($sys_crond_timer as $format) {
            $nows[] = date($format, $time);
        }

        return $nows;
    }

    /**
     * 删除
     */
    public function toDel($id)
    {
        if($this->where('id',$id)->cache('dbassistantTasks')->delete())
        {
            return recode(10004);
        }else{
            return recode(10104);
        }
        
    }



}