<?php
namespace addons\distribution;	// 注意命名空间规范

use addons\distribution\lib\Order as LibOrder;
use app\b2c\model\AftersalesItems;
use app\b2c\model\Order;
use app\base\model\Refund;
use app\common\Addons;

/**
 * 分销插件
 */
class Addon extends Addons
{
    public $code = "distribution";               //插件标识  必须与文件夹名完全一样
    public $name = "分销插件";               //插件名称
    public $description = "分销功能，最多2级分销";        //插件描述
    public $author = "SIN";             //作者
    public $version = "V1.0.0";            //版本
    public $relyon = [                  //依赖，安装此插件需要满足的条件，那些应用和插件必须先安装
        'app' => ['base','b2c'],
        'addons' => []
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'install.sql';
        if(file_exists($file)){
            $sql = file_get_contents($file);
            $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
            $list = explode(';', $sql);
            for ($i = 0; $i < count($list); $i++) {
                if (trim($list[$i])) {
                    \think\facade\Db::execute(trim($list[$i]));
                }
            }
        }
        
        return recode(10000);
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        //卸载的时候，不删除表了，否则数据会丢失
        // $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'uninstall.sql';
        // if(file_exists($file)){
        //     $sql = file_get_contents($file);
        //     $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
        //     $list = explode(';', $sql);
        //     for ($i = 0; $i < count($list); $i++) {
        //         if (trim($list[$i])) {
        //             \think\facade\Db::execute(trim($list[$i]));
        //         }
        //     }
        // }
        return recode(10000);
    }

    /**
     * 应用初始化
     */
    public function init()
    {
        return recode(10000);
    }

    /**
     * 配置信息传到接口端
     */
    public function baseManageConfCommon($conf)
    {
        $conf->addons['distribution'] = [
            'order' => [
                'status' => [
                    1 => '待结算',
                    2 => '已结算',
                ],
            ],
        ];
    }

    //订单支付成功
    public function b2cOrderPaySuccess(Order $info){
        $lib = new LibOrder();
        $lib->toAdd($info['order_id']);
        
        return true;
    }

    //订单归档成功
    public function b2cOrderCompleteSuccess($order_id){
        $lib = new LibOrder();
        $lib->toCompany($order_id);

        return true;
    }

    //退款单审核成功
    public function baseRefundAuditSuccess(Refund $info){
        if($info['type'] != 'order'){
            return true;
        }
        $source_id = explode('-', $info['source_id']);
        $m = new AftersalesItems();
        $where = [
            ['aftersales_id', '=', $source_id[0]],
            ['refund_money', '>', 0]
        ];
        $items = $m->field('order_items_id,refund_money')->where($where)->select();
        if($items->isEmpty()){
            return true;
        }
        $items = $items->toArray();
        $lib = new LibOrder();
        $lib->toRefund($source_id[1], $items);

        return true;
    }



}