<?php
namespace addons\distribution\controller\manage;

use addons\distribution\model\Order as ModelOrder;
use app\common\addons\controller\AddonsManageApi;
use app\base\model\Iotask;
use app\base\model\User;

class Order extends AddonsManageApi
{
    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','sortable'=>'custom','show'=>true],
                ['label' => 'b2c.order_id', 'prop' => 'order_id', 'show'=>true],
                ['label' => 'distribution.user', 'prop' => 'user_show_field', 'show'=>true],
                ['label' => 'status', 'prop' => 'status', 'show'=>true],
                ['label' => 'distribution.lv', 'prop' => 'lv', 'show'=>true],
                ['label' => 'distribution.money', 'prop' => 'money', 'show'=>true],
                ['label' => 'distribution.refund', 'prop' => 'refund', 'show'=>true],
                ['label' => 'ctime', 'prop' => 'ctime','sortable'=>'custom', 'show'=>true],
                ['label' => 'utime', 'prop' => 'utime','sortable'=>'custom', 'show'=>true],
                //['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 列表
     */
    public function table()
    {
        $page = input('param.page/d', 1);
        $limit = input('param.limit/d', 10);
        $order = input('param.order/s', 'ctime desc');
        $where = $this->tableWhere(input('param.filter/a',[]));
        $type = input('param.type/s','list');       //list,count
    
        $m = new ModelOrder();
        $data = [];
        if($type == 'list'){
            $field = "*";
            $data['list'] = $m->field($field)->where($where)->page($page, $limit)->order($order)->select();
            foreach($data['list'] as &$v){
                $v['user_show_field'] = User::showFieldById($v['user_id']);
            }

            if(input('?param.fields')){
                $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'distribution-Order-table');
            }
        }elseif($type == 'count'){
            $data['count'] = $m->where($where)->count();
        }elseif($type == 'export'){
            $m = new Iotask();
            return $m->manageExport("distribution",[
                'class' => self::class,
                'method' => 'table',
                'param' => [
                    'order' => $order,
                    'filter' => input('param.filter/a',[])
                ]
            ]);
        }
        
        return recode(10000, $data);
    }

    /**
     * where条件整理
     */
    private function tableWhere($filter)
    {
        $where = [];
        if(isset($filter['id'])){
            $where[] = ['id', 'in', $filter['id']];
        }
        if(isset($filter['lv'])){
            $where[] = ['lv', 'in', $filter['lv']];
        }
        if(isset($filter['order_id'])){
            $where[] = ['order_id', 'like', "%".$filter['order_id']."%"];
        }
        if(isset($filter['status'])){
            $where[] = ['status', '=', $filter['status']];
        }
        if(isset($filter['user_id'])){
            $where[] = ['user_id', 'in', $filter['user_id']];
        }
        if(isset($filter['ctime'][0])){
            $where[] = ['ctime', '>=', $filter['ctime'][0]];
        }
        if(isset($filter['ctime'][1])){
            $where[] = ['ctime', '<', $filter['ctime'][1]];
        }

        return $where;
    }


}