<?php
namespace addons\distribution\controller\manage;

use addons\distribution\model\Goods;
use app\b2c\model\Goods as ModelGoods;
use app\common\addons\controller\AddonsManageApi;
use app\base\model\Setting as ModelSetting;
use app\base\model\UserGrade;

class Setting extends AddonsManageApi
{

    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','sortable'=>'custom','show'=>true],
                ['label' => 'distribution.goods_name', 'prop' => 'goods_name', 'show'=>true],
                ['label' => 'distribution.lv1', 'prop' => 'lv1', 'show'=>true],
                ['label' => 'distribution.lv2', 'prop' => 'lv2', 'show'=>true],
                ['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 列表
     */
    public function getConf()
    {
        $data = [
            'base' => [
                'status' => ModelSetting::toGet('distribution.status', 1),          //分销状态，1开启，2关闭
                'onvalue' => ModelSetting::toGet('distribution.onvalue', ''),       //分销规则
                'rule' => [
                    'base' => [
                        'name' => '基础分销',
                        'description' => '直推用户获取X%佣金,间推用户获得X%佣金',
                        'data' => [
                            'base_lv1' => ModelSetting::toGet('distribution.base_lv1', 0),
                            'base_lv2' => ModelSetting::toGet('distribution.base_lv2', 0)
                        ]
                    ],
                    'grade' => [
                        'name' => '推荐人等级',
                        'description' => '直推是指定用户等级，获取X%佣金,间推用户是指定等级，获取X%佣金，不极差',
                        'data' => $this->getGradeData()
                    ],
                    'goods' => [
                        'name' => '指定商品',
                        'description' => '指定的商品，直推可以获取X%佣金，间推可以获取X%佣金',
                        'data' => []
                    ],
                ],
            ]
        ];
        return recode(10000, $data);
    }

    public function setConf()
    {
        if(!input('?param.conf') || input('param.conf/s') == '' || !input('?param.val')){
            return recode(10100);
        }
        $conf = input('param.conf/s');
        $conf = 'distribution.'.$conf;

        return ModelSetting::toSet($conf, input('param.val/s'));
    }
 
    public function goodsTable(){
        $page = input('param.page/d', 1);
        $limit = input('param.limit/d', 10);
        $order = input('param.order/s', 'id desc');
        $where = [];//$this->goodsTableWhere(input('param.filter/a',[]));
        $type = input('param.type/s','list');       //list,count
    
        $m = new Goods();
        $data = [];
        if($type == 'list'){
            $field = "*";
            $data['list'] = $m->field($field)->where($where)->page($page, $limit)->order($order)->select();
            $m = new ModelGoods();
            foreach($data['list'] as &$v){
                $v['goods_name'] = implode(',',$m->where('id', 'in', $v['goods_ids'])->column('name'));
            }

            if(input('?param.fields')){
                $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'distribution-Setting-goodsTable');
            }
        }elseif($type == 'count'){
            $data['count'] = $m->where($where)->count();
        }
        
        return recode(10000, $data);
    }

    public function goodsInfo(){
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => recode(10106,'',['id'])
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        $m = new Goods();

        $field = "*";
        $data = $m->field($field)->where('id', input('param.id/d'))->find();
        if(!$data){
            return recode(10107);
        }
        return recode(10000, $data);
    }
    
    public function goodsEdit(){
        $m = new Goods();
        if(input('?param.id')){
            return $m->toEdit(input('param.id/d'),input('param.'));
        }else{
            return $m->toAdd(input('param.'));
        }
    }
    
    /**
     * 删除
     */
    public function goodsDel()
    {
        $rule = [
            'id' => 'require'
        ];
        $message = [
            'id' => recode(10106,'',['id'])
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }

        $m = new Goods();
        return $m->toDel(input('param.id/d'));
    }

    private function getGradeData(){
        $m = new UserGrade();
        $grade = $m->select();
        $data = [];
        foreach($grade as $v){
            $data[] = [
                'id' => $v['id'],
                'key' => 'grade_'.$v['id'].'_',
                'name' => $v,
                'lv1' => ModelSetting::toGet('distribution.grade_'.$v['id'].'_lv1', 0),
                'lv2' => ModelSetting::toGet('distribution.grade_'.$v['id'].'_lv2', 0)
            ];
        }
        return $data;
    }


}