<?php
namespace addons\distribution\lib;

use addons\distribution\model\Order as DistributionModelOrder;
use addons\distribution\model\OrderItems as ModelOrderItems;
use app\b2c\model\Order as ModelOrder;
use app\b2c\model\OrderItems;
use app\base\model\Account;
use app\base\model\Setting;
use app\base\model\User;
use app\common\addons\AddonsLib;

/**
 * 订单分销
 */
class Order extends AddonsLib
{
    /**
     * 生成分销订单
     */
    public function toAdd($order_id)
    {
        if(Setting::toGet('distribution.status', '1') != '1'){      //没有开启分销，直接返回
            return recode(10000, '', '没有开启分销规则');
        }

        $m = new ModelOrder();
        $orderInfo = $m->field('order_id,amount,user_id')->where('order_id', $order_id)->find();
        if(!$orderInfo){
            return recode(10100);
        }
        $data = $orderInfo->toArray();
        $oiModel = new OrderItems();
        $data['items'] = $oiModel->field('id as oi_id, goods_id,product_id,pcode,gcode,nums,real_amount')->where('order_id', $order_id)->select()->toArray();
        
        $userModel = new User();
        $userInfo = $userModel->where('id', $data['user_id'])->find();
        if(!$userInfo || $userInfo['account_id'] <= 0){
            return recode(10100, '', '下单用户没有找到');
        }
        $accountModel = new Account();
        $accountInfo = $accountModel->where('id', $userInfo['account_id'])->find();
        if(!$accountInfo){
            return recode(10100, '', '下单账号没有找到');
        }

        //直推
        if($accountInfo['pid'] > 0){
            $paccountInfo = $accountModel->where('id', $accountInfo['pid'])->find();
            if(!$paccountInfo){
                return recode(10100, '', '推荐人账号没有找到');
            }
            $puserInfo = $userModel->where('account_id', $paccountInfo['id'])->find();
            if(!$puserInfo){
                return recode(10100, '', '推荐用户没有找到');
            }

            $data['paccountInfo'] = $paccountInfo->toArray();
            $data['puserInfo'] = $puserInfo->toArray();
            $data['level'] = 1;
            $this->toFx($data);
        }

        //间推
        if(isset($data['paccountInfo']) && $data['paccountInfo']['pid'] > 0){
            $paccountInfo = $accountModel->where('id', $data['paccountInfo']['pid'])->find();
            if(!$paccountInfo){
                return recode(10000);
            }
            $puserInfo = $userModel->where('account_id', $paccountInfo['id'])->find();
            if(!$puserInfo){
                return recode(10000);
            }

            $data['paccountInfo'] = $paccountInfo->toArray();
            $data['puserInfo'] = $puserInfo->toArray();
            $data['level']++;
            $this->toFx($data);
        }
        return recode(10000);
    }

    //去返利
    public function toCompany($order_id){
        $m = new DistributionModelOrder();
        $where = [
            ['order_id', '=', $order_id],
            ['status', '=', 1]
        ];
        $list = $m->where($where)->select();
        foreach($list as $v){
            $re = $m->toCompany($v['id']);
        }

        return recode(10000);
    }

    /**
     * 退款的时候，退佣金
     * @param $order_id 订单号
     * @param $data 二维数组，里面包含order_items_id订单明细id，refund_money退款金额
     */
    public function toRefund($order_id, $data){
        $m = new DistributionModelOrder();
        $where = [
            ['order_id', '=', $order_id],
        ];
        $list = $m->where($where)->select();
        foreach($list as $v){
            $re = $m->toRefund($v['id'], $data);
        }
        return recode(10000);
    }

    private function toFx($data){
        $rule = Setting::toGet('distribution.onvalue', '');
        if($rule == ''){
            return recode(10000, '', '没有勾选分销规则');
        }
        $arr_rule = explode(',', $rule);
        foreach($arr_rule as $v){
            if(! $typeClass = self::getTypeClass($v))
            {
                return recode(10100, '', '分销规则'.$v.'不存在');
            }
            $typeClass->handle($data);
        }
        
        //创建分销订单
        $sdata = [
            'order_id' => $data['order_id'],
            'user_id' => $data['puserInfo']['id'],
            'lv' => $data['level'],
            'money' => 0,
            'refund' => 0
        ]; 
        foreach($data['items'] as $k =>$v){
            if(isset($v['isfx']) && $v['isfx'] && $v['money'] > 0){
                $sdata['money'] += $v['money'];
            }else{
                unset($data['items'][$k]);
            }
        }
        if($sdata['money'] > 0){
            $sdata['money'] = round($sdata['money'], 2);
            $m = new DistributionModelOrder();
            $re = $m->toAdd($sdata);
            if($re['code'] < 10100){
                //添加明细
                foreach($data['items'] as &$j){
                    $j['oid'] = $re['data'];
                }
                $itemsModel = new ModelOrderItems();
                $itemsModel->saveAll($data['items']);
            }

        }

        return recode(10000);
    
    }

    public static function getTypeClass($type) {
        $class = "addons\\distribution\\lib\\rule\\".ucfirst($type);
        if (!class_exists($class)) {
            return false;
        }
        return app()->invokeClass($class);
    } 
 
}