<?php
namespace addons\distribution\lib\rule;

use addons\distribution\model\Goods as ModelGoods;

/**
 * 基础分销
 */
class Goods extends Rule
{
    /**
     * 生成分销订单
     */
    public function handle(&$data)
    {
        foreach($data['items'] as &$v){
            if(!isset($v['isfx'])){
                $v['isfx'] = false;
            }
            if(!isset($v['money'])){
                $v['money'] = 0;
            }

            if(!$v['isfx']){
                $m = new ModelGoods();
                $where = [
                    ['goods_ids', 'find in set', $v['goods_id']]
                ];
                $info = $m->where($where)->find();
                if(!$info){
                    continue;
                }
                if(!isset($info['lv'.$data['level']])){
                    continue;
                }
                $rate = $info['lv'.$data['level']];
                if($rate <= 0){
                    $rate = 0;
                }
                $v['money'] = round($v['real_amount'] * $rate /100,2);
                $v['rate'] = $rate;
                $v['isfx'] = true;
            }
        }
        return true;
    }

 
}