<?php
namespace addons\distribution\lib\rule;

use app\base\model\Setting;

/**
 * 基础分销
 */
class Grade extends Rule
{
    /**
     * 生成分销订单
     */
    public function handle(&$data)
    {
        if($data['puserInfo']['grade'] <= 0){
            return false;
        }
        $rate = Setting::toGet('distribution.grade_'.$data['puserInfo']['grade'].'_lv'.$data['level'], 0);
        if($rate <= 0){
            return false;
        }
        foreach($data['items'] as &$v){
            if(!isset($v['isfx'])){
                $v['isfx'] = false;
            }
            if(!isset($v['money'])){
                $v['money'] = 0;
            }

            if(!$v['isfx']){
                $v['money'] = round($v['real_amount'] * $rate /100,2);
                $v['rate'] = $rate;
                $v['isfx'] = true;
            }
        }


    }

 
}