<?php
namespace addons\distribution\model;

use app\common\addons\AddonsModel;
use think\facade\Validate;

class Goods extends AddonsModel
{
    //校验规则
    protected $rule = [
        'goods_ids' => 'require',
        'lv1' => 'require',
        'lv2' => 'require',
    ];
    //校验规则消息
    protected $message = [
        'goods_ids.require' => ['goods_ids', 'require'],           //可以传空
        'lv1' => ['lv1', 'require'],
        'lv2' => ['lv2', 'require'],
    ];


    /**
     * 添加
     */
    public function toAdd($data)
    {
        $validate = Validate::rule($this->rule)->message($this->message);
        if(!$validate->check($data)){
            return recode(20000,'',veri($validate->getError()));
        }
        
        if($this->save($data))
        {
            return recode(10002,$this->id);
        }else{
            return recode(10102);
        }
    }

    /**
     * 编辑
     */
    public function toEdit($id, $data)
    {
        $validate = Validate::rule($this->rule)->message($this->message);
        if(!$validate->check($data)){
            return recode(10100,'',veri($validate->getError()));
        }
        
        if($this->update($data,['id'=> $id]))
        {
            return recode(10003);
        }else{
            return recode(10103);
        }
    }

    /**
     * 删除
     */
    public function toDel($id)
    {
        if($this->where('id',$id)->delete())
        {
            return recode(10004);
        }else{
            return recode(10104);
        }
        
    }

    // /**
    //  * 显示字段
    //  */
    // public static function showField($info){
    //     return $info['name'];
    // }
    // /**
    //  * 根据id返回显示字段
    //  */
    // public static function showFieldById($id){
    //     $info = self::where('id',$id)->find();
    //     if($info){
    //         return self::showField($info);
    //     }
    //     return "";
    // }

}