<?php
namespace addons\distribution\model;

use app\base\model\BalanceLog;
use app\common\addons\AddonsModel;
use think\facade\Db;
use think\facade\Validate;

class Order extends AddonsModel
{
    protected $autoWriteTimestamp = 'timestamp';
    protected $createTime = 'ctime';
    protected $updateTime = 'utime';

    //校验规则
    protected $rule = [
        'user_id' => 'require',
        'money' => 'require',
    ];
    //校验规则消息
    protected $message = [
        'user_id.require' => ['user_id', 'require'],           //可以传空
        'money' => ['money', 'require'],
    ];


    /**
     * 添加
     */
    public function toAdd($data)
    {
        $validate = Validate::rule($this->rule)->message($this->message);
        if(!$validate->check($data)){
            return recode(20000,'',veri($validate->getError()));
        }
        
        if($this->save($data))
        {
            return recode(10002,$this->id);
        }else{
            return recode(10102);
        }
    }

    /**
     * 编辑
     */
    public function toEdit($id, $data)
    {
        $validate = Validate::rule($this->rule)->message($this->message);
        if(!$validate->check($data)){
            return recode(10100,'',veri($validate->getError()));
        }
        
        if($this->update($data,['id'=> $id]))
        {
            return recode(10003);
        }else{
            return recode(10103);
        }
    }

    /**
     * 完成
     */
    public function toCompany($id)
    {
        $info = $this->where('id',$id)->find();
        if($info['status'] != 1){
            return recode(10100);
        }

        Db::startTrans();
        try {
            $money = $info['money'] - $info['refund'];
            if($money > 0){
                BalanceLog::change('distribution', $info['user_id'], $money,$info['order_id']);
            }
            $info->status = 2;
            $info->save();

            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
        }

        return recode(10001);
    }

    /**
     * 退佣金
     * 
     */
    public function toRefund($id, $data)
    {
        $info = $this->where('id',$id)->find();
        
        $oiModel = new OrderItems();
        $list = $oiModel->where('oid', $id)->select();

        Db::startTrans();
        try {
            $all_refund = 0;
            foreach($list as $v){
                foreach($data as $vv){
                    if($v['oi_id'] == $vv['order_items_id']){
                        $refund = round($vv['refund_money'] * $v['rate'] / 100 , 2);
                        if($refund <= 0){
                            break ;
                        }
                        if($v['refund'] + $refund > $v['money']){
                            $refund = $v['money'] - $v['refund'];
                            $v->refund = $v['money'];
                        }else{
                            $v->refund = $v['refund'] + $refund;
                        }
                        $all_refund += $refund;
                        $v->save();
                    }
                } 
            }

            if($all_refund > 0){
                $info->refund += $all_refund;
                $info->save();

                if($info['status'] == 2){
                    BalanceLog::change('distributionRefund', $info['user_id'], $all_refund,$info['order_id']);    
                }
            }

            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
        }

        return recode(10001);
    }

    /**
     * 删除
     */
    public function toDel($id)
    {
        if($this->where('id',$id)->delete())
        {
            return recode(10004);
        }else{
            return recode(10104);
        }
        
    }

}