--
-- 表的结构 `jshop_addons_distribution_goods`
--

CREATE TABLE IF NOT EXISTS `jshop_addons_distribution_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_ids` varchar(1000) NOT NULL COMMENT '商品id，多个用英文逗号分隔',
  `lv1` decimal(7,2) UNSIGNED NOT NULL COMMENT '直推',
  `lv2` decimal(7,2) UNSIGNED NOT NULL COMMENT '间推',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- 表的结构 `jshop_addons_distribution_order`
--

CREATE TABLE IF NOT EXISTS `jshop_addons_distribution_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(30) NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态，1待结算，2已结算',
  `lv` smallint(6) NOT NULL DEFAULT '1' COMMENT '级',
  `money` decimal(7,2) NOT NULL,
  `refund` decimal(7,2) NOT NULL,
  `ctime` timestamp NOT NULL,
  `utime` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- 表的结构 `jshop_addons_distribution_order_items`
--

CREATE TABLE IF NOT EXISTS `jshop_addons_distribution_order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` int(11) NOT NULL COMMENT '关联分销订单主体表',
  `oi_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `pcode` varchar(30) NOT NULL,
  `gcode` varchar(30) NOT NULL,
  `nums` smallint(5) NOT NULL,
  `real_amount` decimal(10,2) NOT NULL,
  `money` decimal(7,2) NOT NULL,
  `refund` decimal(7,2) NOT NULL DEFAULT '0.00',
  `rate` decimal(5,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;