<?php
namespace addons\normstore;	// 注意命名空间规范

use app\b2c\model\Aftersales;
use app\b2c\model\Delivery;
use app\b2c\model\Order;
use app\b2c\model\OrderItems;
use app\b2c\model\Reship;
use app\b2c\model\StockFreeze;
use app\base\model\Payments;
use app\base\model\Refund;
use app\common\Addons;
use app\wms\model\StockLog;

/**
 * 管易CERP标准小店对接插件
 */
class Addon extends Addons
{
    public $code = "normstore";               //插件标识  必须与文件夹名完全一样
    public $name = "管易CERP标准小店对接插件";               //插件名称
    public $description = "通过此插件，和管易cerp的标准小店进行对接";        //插件描述
    public $author = "SIN";             //作者
    public $version = "V1.0.0";            //版本
    public $relyon = [                  //依赖，安装此插件需要满足的条件，那些应用和插件必须先安装
        'app' => [],
        'addons' => []
    ];



    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'install.sql';
        if(file_exists($file)){
            $sql = file_get_contents($file);
            $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
            $list = explode(';', $sql);
            for ($i = 0; $i < count($list); $i++) {
                if (trim($list[$i])) {
                    \think\facade\Db::execute(trim($list[$i]));
                }
            }
        }
        
        return recode(10000);
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        // $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'uninstall.sql';
        // if(file_exists($file)){
        //     $sql = file_get_contents($file);
        //     $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
        //     $list = explode(';', $sql);
        //     for ($i = 0; $i < count($list); $i++) {
        //         if (trim($list[$i])) {
        //             \think\facade\Db::execute(trim($list[$i]));
        //         }
        //     }
        // }
        return recode(10000);
    }

    /**
     * 应用初始化
     */
    public function init()
    {
        return recode(10000);
    }

    /**
     * 订单支付成功，扣减总库存，释放冻结库存
     * 注意：
     *     1. 需要在订单发货的时候不扣减库存，修改Order模型orderShip方法
     *     2. 需要注释b2c模型下的Subscribe里的如下事件
     *          StockFreeze::class,'b2cOrderItemsShipSuccess'
     *          StockFreeze::class,'b2cAftersalesAuditSuccess'
     */
    public function basePaymentsPaySuccess(Payments $pinfo){
        //判断是否是订单类型的支付单
        if($pinfo['type'] != 'order'){
            return true;
        }

        $sfModel = new StockFreeze();

        $orders = explode(',', $pinfo['source_ids']);
        foreach($orders as $order_id){
            $oiModel = new OrderItems();
            $oilist = $oiModel->where('order_id', $order_id)->select();
            foreach($oilist as $v){
                //扣减库存
                $re = StockLog::change("sale",config('addons.normstore.warehouse_code', ''), $v['pcode'], $v['nums'],$v['order_id'].'-'.$v['id']);
                //dump($re);
                //释放冻结库存
                $re = $sfModel->unFreeze($v['order_id'], $v['id'], $v['nums']);
                //dump($re);
            }
        }

        return true;

    }

    /**
     * 
     * 'b2cAftersalesAddSuccess' => 'b2cAftersalesAddSuccess',         //添加售后单成功
      *      'b2cAftersalesEditSuccess' => 'b2cAftersalesEditSuccess',       //售后单编辑
       *     'b2cAftersalesAuditSuccess' => 'b2cAftersalesAuditSuccess',     //售后单审核通过
        *    'b2cDeliveryReceiptSuccess' => 'b2cDeliveryReceiptSuccess',           //确认收货成功
         *   'baseRefundEditSuccess' => 'baseRefundEditSuccess',             //退款单编辑
          *  'baseRefundRefundSuccess' => 'baseRefundRefundSuccess',           //退款单退款成功或失败
     * 
     */

    //
    public function b2cAftersalesAddSuccess(Aftersales $info){
        $this->orderUpUtime($info['order_id']);
        return true;
    }
    public function b2cAftersalesEditSuccess(Aftersales $info){
        $this->orderUpUtime($info['order_id']);
        return true;
    }
    public function b2cAftersalesAuditSuccess(Aftersales $info){
        $this->orderUpUtime($info['order_id']);
        return true;
    }
    public function b2cDeliveryReceiptSuccess(Delivery $info){
        $orders = explode(',', $info['order_ids']);
        foreach($orders as $order_id){
            $this->orderUpUtime($order_id);
        }
        return true;
    }
    public function baseRefundEditSuccess(Refund $info){
        if($info['type'] == 'order'){
            $s = explode('-', $info['source_id']);
            $this->aftersalesUpUtime($s[0]);
            if(isset($s[1])){
                $this->orderUpUtime($s[1]);
            }
        }
        return true;
    }
    public function baseRefundRefundSuccess($refund_id){
        $m = new Refund();
        $info = $m->where('refund_id',$refund_id)->find();
        if($info){
            if($info['type'] == 'order'){
                $s = explode('-', $info['source_id']);
                $this->aftersalesUpUtime($s[0]);
                if(isset($s[1])){
                    $this->orderUpUtime($s[1]);
                }
            }   
        }
        return true;
    }

    public function b2cReshipSend(Reship $info){
        $this->aftersalesUpUtime($info['aftersales_id']);

        return true;
    }

    public function b2cReshipConfirm(Reship $info){
        $this->aftersalesUpUtime($info['aftersales_id']);
        return true;
    }


    //更新订单更新时间
    private function orderUpUtime($order_id){
        $m = new Order();
        $info = $m->where('order_id', $order_id)->find();
        
        if($info){
            $info->utime = date('Y-m-d H:i:s');
            return $info->save();
        }
        return false;
    }

    //更新售后单更新时间
    private function aftersalesUpUtime($aftersales_id){
        $m = new Aftersales();
        $info = $m->where('aftersales_id', $aftersales_id)->find();
        
        if($info){
            $info->utime = date('Y-m-d H:i:s');
            return $info->save();
        }
        return false;
    }


}