<?php
return [
    'config' => [
        [
            'prop' => 'appKey',
            'label' => 'appKey',
            'type' => 'text',
            'required' => true,
            'default' => '',
            'rules' => [],
        ],
        [
            'prop' => 'secret',
            'label' => 'secret',
            'type' => 'text',
            'required' => true,
            'default' => '',
            'rules' => [],
        ],
        [
            'prop' => 'warehouse_code',
            'label' => 'warehouse_code',
            'type' => 'text',
            'required' => true,
            'text' => '库存对应的仓库编码',
            'default' => '',
            'rules' => [],
        ],
        [
            'prop' => 'message',
            'label' => '请求地址',
            'type' => 'message',
            'default' => 'https://域名/addons/normstore/api/index.html',
            'value' => 'https://域名/addons/normstore/api/index.html',
            'rules' => [],
        ],
    ],

    //物流公司对应编码
    'express_code' => [
        'YTO' => 'YTO',                //cerp的物流公司编码对应系统里的物流编码，cerp编码=>系统内编码
        'ZTO' => 'ZTO'
    ],
    //支付方式对应编码
    'payments' => [
        'wechatpay' => 'weixin',        //微信
        'alipay' => 'zhifubao',         //支付宝
        //'balance' => 'balance',      //余额
        'offline' => 'cash'             //现金
    ],
    
    'api' => [
        'manage' => [                               //管理端接口，login默认是true，默认登录,登录的也是后端账号
            'normstore' => [
                'name' => 'CERP标准小店对接管理',
                'description' => '',
                'children' => [
                    'Logs' => [
                        'name' => 'CERP请求日志',
                        'description' => '',
                        'children' => [
                            'table' => [
                                'name' => '请求列表',
                                'description' => '',
                            ],
                        ]
                    ],
                ]
            ],
        ],
        'site' => []
    ],
    'event' => [            //事件
        'bind' => [
                            //暂时没用
        ],
        'listen' => [               //事件名称 => addon内的方法名称
            'basePaymentsPaySuccess' => 'basePaymentsPaySuccess',        //支付成功

            //以下都是为了单纯更新订单utime
            'b2cAftersalesAddSuccess' => 'b2cAftersalesAddSuccess',         //添加售后单成功
            'b2cAftersalesEditSuccess' => 'b2cAftersalesEditSuccess',       //售后单编辑
            'b2cAftersalesAuditSuccess' => 'b2cAftersalesAuditSuccess',     //售后单审核通过
            'b2cDeliveryReceiptSuccess' => 'b2cDeliveryReceiptSuccess',           //确认收货成功
            'baseRefundEditSuccess' => 'baseRefundEditSuccess',             //退款单编辑
            'baseRefundRefundSuccess' => 'baseRefundRefundSuccess',           //退款单退款成功或失败
            'b2cReshipSend' => 'b2cReshipSend',                             //退货单用户邮寄出
            'b2cReshipConfirm' => 'b2cReshipConfirm',                       //退货单仓库收货
        ]
    ],
    "menus" => [
        [
            'key' => 'normstore.logslist',                              //日志菜单
            'name' => 'normstore.menu_logslist',
            'icon' => 'cssgg/poll',
            'path' => '/addons/normstore/index/index',
            'manageapi' => 'normstore-Logs-table',
            'pkey' => 'base.addonsManage',
            'sort' => 100
        ],
    ]
];