<?php
namespace addons\normstore\controller;

use addons\normstore\lib\Api as LibApi;
use addons\normstore\model\Logs;
use app\common\addons\controller\AddonsController;

//cer调用此接口
class Api extends AddonsController
{
    public function index(){
        $request = input('post.');
        
        return self::response($this->route($request), $request);
    }

    //组装响应数据
    private static function response($data, $request){
        $re = [
            'success' => true,
            'request_method' => isset($request['method'])?$request['method']:"",
            'data' => $data['data']
        ];
        if($data['code'] >= 10100){
            $re['success'] = false;
            $re['error_code'] = $data['code'];
            $re['error_desc'] = $data['msg'];
            $re['sub_error_code'] = '';
            $re['sub_error_desc'] = '';
        }

        //保存日志
        $logs = [
            'method' => $re['request_method'],
            'request' => json_encode($request, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
            'response' => json_encode($re, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
            'recode' => $data['code'],
            'msg' => $data['msg']
        ];
        $logsModel = new Logs();
        $logsModel->save($logs);

        return json($re);
    } 

    /**
     * 路由接口并返回执行结果
     */
    private function route($request) 
    {
        if(
            !isset($request['appkey']) || 
            !isset($request['method']) || 
            !isset($request['data']) || 
            !isset($request['sign'])
        ){
            return recode(10100, '', '参数不存在，请确保appkey、method、data、sign都存在');
        }

        //先确定appkey是否对应
        if($request['appkey'] != config('addons.normstore.appKey', '')){
            return recode(10100, '', 'appkey不对应，或系统里没有维护，请先维护appkey');    
        }


        $arr = [
            'order.query' => 'orderQuery',
            'item.query' => 'itemQuery',
            'order.delivery' => 'orderDelivery',
            'item.stock.update' => 'itemStockUpdate',
            'aftersale.order.query' => 'aftersaleOrderQuery',
        ];
        if(!isset($arr[$request['method']])){
            return recode(10100, '', 'method不存在');
        }

        //验签
        if(!self::veriSign($request)){
            return recode(10100, '', '验签失败');
        }

        //去执行
        $data = $request['data'];
        if(is_string($data)){
            $data = json_decode($data, true);
        }
        if (is_callable([LibApi::class, $arr[$request['method']]])) {
            return call_user_func_array([LibApi::class, $arr[$request['method']]], [$data]);
        } else {
            return recode(11275);
        }
  
    }

    //验证签名
    private static function veriSign($data){
        if(!isset($data['sign'])){
            return false;
        }
        if($data['sign'] == self::sign($data, config('addons.normstore.secret', ''))){
            return true;
        }
        return true;        //测试先写死
        return false;
    }

    /**
     * 签名
     * @param $data
     * @param $secret
     * @return string
     */
    private static function sign($data, $secret)
    {
        if (empty($data)) {
            return "";
        }
        unset($data['sign']); //可选，具体看传参
        $data = self::json_encode_ch($data);
        $sign = strtoupper(md5($secret . $data . $secret));
        return $sign;
    }


    /**
     * 汉字转换
     * @param $arr
     * @return string
     */
    private static function json_encode_ch($arr)
    {
        return urldecode(json_encode(self::url_encode_arr($arr)));
    }
    
    /**
     * URL转换
     * @param $arr
     * @return array|string
     */
    private static function url_encode_arr($arr)
    {
        if (is_array($arr)) {
            foreach ($arr as $k => $v) {
                $arr[$k] = self::url_encode_arr($v);
            }
        } else if (!is_numeric($arr) && !is_bool($arr)) {
            $arr = urlencode($arr);
        }
        return $arr;
    }
    
}