<?php
namespace addons\normstore\controller\manage;

use addons\normstore\model\Logs as ModelLogs;
use app\common\addons\controller\AddonsManageApi;

class Logs extends AddonsManageApi
{
    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','show'=>true],
                ['label' => 'normstore.method', 'prop' => 'method', 'show'=>true],
                ['label' => 'normstore.request', 'prop' => 'request','show-overflow-tooltip'=>true, 'show'=>true],
                ['label' => 'normstore.response', 'prop' => 'response','show-overflow-tooltip'=>true, 'show'=>true],
                ['label' => 'normstore.recode', 'prop' => 'recode', 'show'=>true],
                ['label' => 'normstore.msg', 'prop' => 'msg', 'show'=>true],
                ['label' => 'normstore.ctime', 'prop' => 'ctime', 'show'=>true],
                //['label' => 'utime', 'prop' => 'utime', 'show'=>true],
                //['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 列表
     */
    public function table()
    {
        $page = input('param.page/d', 1);
        $limit = input('param.limit/d', 10);
        $order = input('param.order/a', ['id' => 'desc']);
        $where = $this->tableWhere(input('param.filter/a',[]));
        $type = input('param.type/s','list');
    
        $m = new ModelLogs();
        $data = [];
        if($type == 'list'){
            $field = "*";
            $data['list'] = $m->field($field)->where($where)->page($page, $limit)->order($order)->select();
            
            if(input('?param.fields')){
                $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'normstore-Logs-table');
            }
        }elseif($type == 'count'){
            $data['count'] = $m->where($where)->count();
        }
        
        return recode(10000, $data);
    }

    

    /**
     * 账户的where条件整理
     */
    private function tableWhere($filter)
    {
        $where = [];
        if(isset($filter['id'])){
            $where[] = ['id', 'in', $filter['id']];
        }
        if(isset($filter['msg'])){
            $where[] = ['request|response|msg', 'like', "%".$filter['msg']."%"];
        }
        
        if(isset($filter['method'])){
            $where[] = ['method', '=', $filter['method']];
        }
        if(isset($filter['status'])){
            if($filter['status'] == 1){
                $where[] = ['recode', '<', 10100];
            }else{
                $where[] = ['recode', '>=', 10100];    
            }
        }
        if(isset($filter['ctime'][0])){
            $where[] = ['ctime', '>=', $filter['ctime'][0]];
        }
        if(isset($filter['ctime'][1])){
            $where[] = ['ctime', '<', $filter['ctime'][1]];
        }

        return $where;
    }
}