<?php
namespace addons\normstore\lib;

use app\b2c\model\Aftersales;
use app\b2c\model\AftersalesItems;
use app\b2c\model\Goods;
use app\b2c\model\Order;
use app\b2c\model\OrderItems;
use app\b2c\model\Products;
use app\b2c\model\Reship;
use app\base\model\Account;
use app\base\model\Addons;
use app\base\model\Area;
use app\base\model\Payments;
use app\base\model\Refund;
use app\base\model\User;
use app\common\addons\AddonsLib;
use app\wms\model\StockLog;

/**
 * 接口实现类
 */
class Api extends AddonsLib
{
    //平台订单查询接口（order.query）
    //https://vip.kingdee.com/article/310065144263129088?productLineId=3&isKnowledge=2&lang=zh-CN
    public static function orderQuery($data){
        if(
            !isset($data['tid']) && 
            (!isset($data['start_time']) || !isset($data['end_time']))
        ){
            return recode(10100, '', '请求参数不正确');
        }
        $where = [];
        if(isset($data['tid'])){
            $where[] = ['order_id', '=', $data['tid']];
        }else{
            $where[] = ['utime', '>=', $data['start_time']];
            $where[] = ['utime', '<', $data['end_time']];
        }
        $limit = isset($data['page_size'])?$data['page_size']:20;
        $page = isset($data['page_no'])?$data['page_no']:1;

        $order_list = [];

        $orderModel = new Order();
        $field = [];
        $list = $orderModel->field($field)->where($where)->page($page, $limit)->order('ctime asc')->select();
        foreach($list as $v){
            $status = "";
            if($v['status'] == 1){
                $status = "WAIT_BUYER_PAY";
                if($v['pay_status'] == 2){
                    $status = "WAIT_SELLER_SEND_GOODS";
                }
                if($v['ship_status'] == 2){
                    $status = "SELLER_CONSIGNED_PART";
                }elseif($v['ship_status'] == 3){
                    $status = "WAIT_BUYER_CONFIRM_GOODS";   
                }

            }elseif($v['status'] == 2){
                $status = "TRADE_FINISHED";
            }else{
                $status = "TRADE_CLOSED_BY_TAOBAO";
            }

            $one = [
                'shipping_type' => 'express',
                'status' => $status,
                'order_type' => 'Sales',
                'buyer_memo' => $v['memo'],
                'seller_memo' => $v['mark'],
                'modified' => $v['utime'],
                'buyer_nick' => self::getNickname($v['user_id']),
                'created' => $v['ctime'],
                'tid' => $v['order_id'],
                'pay_time' => $v['pay_time'],
                'point_fee' => $v['point_money'],
                'total_fee' => $v['amount'],
                'post_fee' => $v['cost_freight'],
                'receiver_name' => $v['ship_address'],
                'receiver_country' => '中国',
                'receiver_state' => '',
                'receiver_city' => '',
                'receiver_district' => '',
                'receiver_town' => '',
                'receiver_address' => $v['ship_address'],
                'receiver_zip' => '450000',
                'receiver_mobile' => $v['ship_mobile'],
                'consign_time' => $v['ship_time'],
                'buyer_email' => '',
                'orders' => self::orderItems($v['order_id']),
                'payments' => self::payments($v['order_id']),
            ];
            $area_arr = explode(',', Area::getFullName($v['ship_area_code'], ','));
            if(isset($area_arr[0])){
                $one['receiver_state'] = $area_arr[0];
            }
            if(isset($area_arr[1])){
                $one['receiver_city'] = $area_arr[1];
            }
            if(isset($area_arr[2])){
                $one['receiver_district'] = $area_arr[2];
            }
            if(isset($area_arr[3])){
                $one['receiver_town'] = $area_arr[3];
            }

            $order_list[] = $one;

        }

        return recode(10000,['order_list' => $order_list]);
    }


    //获取用户昵称
    private static function getNickname($user_id){
        $um = new User();
        $uinfo = $um->where('id', $user_id)->find();
        if(!$uinfo){
            return $user_id;
        }
        $am = new Account();
        $ainfo = $am->where('id', $uinfo['account_id'])->find();
        if($ainfo){
            return $ainfo['nickname'];
        }
        return $user_id;
    }

    private static function payments($order_id){
        $configFile = Addons::getAddon('normstore')->getConfigFile();
        $plist = $configFile['payments'];
        $m = new Payments();
        $where = [
            ['source_ids', 'find in set', $order_id],
            ['status', '=', 2]
        ];
        $list = $m->where($where)->select();
        $re = [];
        foreach($list as $v){
            $payment_type = "QTZF";
            if(isset($plist[$v['payment_code']])){
                $payment_type = $plist[$v['payment_code']];
            }

            $one = [
                'payment' => $v['money'],
                'payment_type' => $payment_type,
                'payment_time' => $v['payment_time'],
            ];
            $re[] = $one;
        }
        return $re;
    }

    //订单明细
    private static function orderItems($order_id){
        $m = new OrderItems();
        $list = $m->where('order_id', $order_id)->select();
        $re = [];
        foreach($list as $v){
            $one = [
                'oid' => $v['id'],
                'refund_status' => self::oiRefundStatus($v['id']),
                'iid' => $v['goods_id'],
                'outer_iid' => $v['gcode'],
                'title' => $v['name'],
                'sku_id' => $v['pcode'],
                'sku_properties_name' => $v['spec'],
                'origin_price' => $v['price'],
                'price' => $v['price'],
                'num' => $v['nums'],
            ];
            $re[] = $one;
        }

        return $re;
    } 

    //获取售后状态
    private static function oiRefundStatus($oi_id){
        $aiModel = new AftersalesItems();
        $where = [
            ['ai.order_items_id', '=', $oi_id],
        ];
        $info = $aiModel
            ->alias('ai')
            ->field('a.status, a.aftersales_id, a.refund, ai.refund_money')
            ->join((new Aftersales())->getTable().' a', 'a.aftersales_id = ai.aftersales_id')
            ->where($where)
            ->order('a.utime desc')
            ->find();
        if(!$info){          //如果有售后通过的售后单，查询退款单状态
            return "";
        }

        //查询是审核通过的状态
        if($info['status'] == 2){
            if($info['refund_money'] <= 0){        //如果本条明细不需要退款，name就直接返回成功
                return 'SUCCESS';
            }
            $rModel = new Refund();
            $rWhere = [
                ['source_id', 'like', '%'.$info['aftersales_id'].'%'],
                ['status', '=', 3]
            ];
            $rinfo = $rModel->where($rWhere)->cache(5)->find();
            if($rinfo){
                return 'SUCCESS';
            }
            return 'WAIT_SELLER_AGREE';
        }
        
        //未审核的
        if($info['status'] == 1){
            return 'WAIT_SELLER_AGREE';
        }

        if($info['status'] == 3){
            return 'CLOSED';
        }
        return '';

    }


    //平台订单发货接口（order.delivery）
    //https://vip.kingdee.com/article/310065236319337728?productLineId=3&isKnowledge=2&lang=zh-CN
    public static function orderDelivery($data){
        if(!isset($data['split'])){
            $data['split'] = 1;
        }

        if($data['split'] == 1){
            //获取所有待发货的明细
            $allfx = self::getAllFx($data['tid']);
            if(count($allfx)<= 0){
                return recode(10100, '', '没有需要发货的订单明细');
            }

            //物流公司编码做转化
            $lre = self::cerplcodeToMylcode($data['logistics_code']);
            if($lre['code'] >= 10100){
                return $lre;
            }

            $f[] = [
                'logistics_code' => $lre['data'],
                'tracking_number' => $data['tracking_number'],
                'items' => $allfx
            ];
        }else{
            $f = $data['packageDetails'];
            //oid转pcode
            $oiModel = new OrderItems();
            foreach($f as $k => $v){
                $it = [];
                foreach($v['items'] as $a => $b){
                    $oiinfo = $oiModel->where('id', $b['oid'])->find();
                    if($oiinfo){
                        $it[$oiinfo['pcode']] = $b['qty'];
                    }
                }
                $f[$k]['items'] = $it;

                //物流公司编码做转化
                $lre = self::cerplcodeToMylcode($v['logistics_code']);
                if($lre['code'] >= 10100){
                    return $lre;
                }
                $f[$k]['logistics_code'] = $lre['data'];
            }

        }

        //去发货
        $n = 0;
        $en = 0;
        $errmsg = "";
        foreach($f as $v){
            $orderModel = new Order();

            $re = $orderModel->ship([
                'order_ids' => $data['tid'],
                'logi_code' => $v['logistics_code'],      //物流公司需要转码
                'logi_no' => $v['tracking_number'],
                'warehouse_code' => config('addons.normstore.warehouse_code', ''),         //仓库编码
                'items' => $v['items']
            ]);
            if($re['code'] < 10100){
                $n++;
            }else{
                $en++;
                $errmsg .= $re['msg'].';';
            }
        }
        $error_msg = "发货成功".$n."单";
        if($en > 0){
            $error_msg .= ",失败".$en."单";
        }
        if($errmsg != ""){
            $error_msg .= ",失败原因：".$errmsg;
        }

        $data = [
            'operate_result' => true,
            'error_msg' => $error_msg
        ];
        return recode(10000,$data);
    }

    //cerp物流公司编码转系统内物流公司编码
    private static function cerplcodeToMylcode($cerpCode){
        $configFile = Addons::getAddon('normstore')->getConfigFile();
        $ecode = $configFile['express_code'];
        if(!isset($ecode[$cerpCode])){
            return recode(10100, '', '编码：'.$cerpCode." 在插件配置文件中没有维护，请先维护此物流公司方式");
        }

        if(!config('?shop.base.logistics.'.$ecode[$cerpCode])){
            return recode(10100, '', '物流公司编码：'.$ecode[$cerpCode]." 系统内没维护，请先添加此物流公司");    
        }
        return recode(10000, $ecode[$cerpCode]);

    }


    //获取所有待发货的订单明细
    private static function getAllFx($order_id){
        $oiModel = new OrderItems();
        $list = $oiModel->where('order_id', $order_id)->select();
        $re = [];
        foreach($list as $v){
            $re[$v['pcode']] = $v['nums'];
        }
        return $re;
    } 

    //平台商品查询接口（item.query）
    //https://vip.kingdee.com/article/310065486836877312?productLineId=3&isKnowledge=2&lang=zh-CN
    public static function itemQuery($data){
        $where = [];
        if(isset($data['start_time'])){
            $where[] = ['utime', '>=', $data['start_time']];
        }
        if(isset($data['end_time'])){
            $where[] = ['utime', '<', $data['end_time']];
        }
        if(isset($data['item_id'])){
            $where[] = ['id', '=', $data['item_id']];
        }
        if(isset($data['item_code'])){
            $where[] = ['code', '=', $data['item_code']];
        }
        if(isset($data['barcode'])){
            $where[] = ['barcode', '=', $data['barcode']];
        }

        if(!isset($data['status'])){
            $data['status'] = 2;
        }
        //1全部，2出售中，3待售
        if($data['status'] == 2){
            $where[] = ['marketable', '=', 1];
        }
        if($data['status'] == 3){
            $where[] = ['marketable', '=', 2];
        }

        $pcode = "";        //如果查的是货品编码，货品编码保存到这里
        if(isset($data['sku_id'])){     //sku_id用货品编码来对应
            $pmodel = new Products();
            $pinfo = $pmodel->where('code', $data['sku_id'])->find();
            if($pinfo){
                $pcode = $pinfo['pcode'];
                $where[] = ['id', '=', $pinfo['goods_id']];
            }else{
                $where[] = ['id', '=', time()];
            }
        }
        if(isset($data['sku_code'])){     //sku_id用货品编码来对应
            $pmodel = new Products();
            $pinfo = $pmodel->where('code', $data['sku_code'])->find();
            if($pinfo){
                $pcode = $pinfo['pcode'];
                $where[] = ['id', '=', $pinfo['goods_id']];
            }else{
                $where[] = ['id', '=', time()];
            }
        }

        $limit = isset($data['page_size'])?$data['page_size']:20;
        $page = isset($data['page_no'])?$data['page_no']:1;

        $item_list = [];

        $goodsModel = new Goods();
        $list = $goodsModel->where($where)->page($page, $limit)->order('ctime asc')->select();
        foreach($list as $v){
            $status = $v['marketable'] + 1;
            $one = [
                'item_id' => $v['id'],
                'barcode' => $v['barcode'],
                'item_code' => $v['code'],
                'item_name' => $v['name'],
                'status' => $status,
                'price' => '0',
                'skus' => self::getSkus($v['id'], $status, $pcode)
            ];
            $item_list[] = $one;
        }


        $data = [
            'item_list' => $item_list
        ];
        return recode(10000, $data);
    }

    //获取货品信息
    private static function getSkus($goods_id, $status, $pcode=""){
        $where = [
            ['goods_id', '=', $goods_id]
        ];
        if($pcode != ""){
            $where[] = ['code', '=', $pcode];
        }
        $m = new Products();
        $list = $m->where($where)->select();
        $re = [];
        foreach($list as $v){
            $sku_name = "";
            $spec = json_decode($v['spec']);
            foreach($spec as $ll => $lk){
                $sku_name .= ",".$ll.":".$lk;
            }
            $sku_name = substr($sku_name, 1);

            $one = [
                'barcode' => $v['barcode'],
                'sku_id' => $v['code'],
                'sku_code' => $v['code'],
                'sku_name' => $sku_name,
                'status' => $status,
                'price' => $v['price'],
            ];
            $re[] = $one;
        }
        return $re;
    }


    //平台商品库存更新接口（item.stock.update）
    //https://vip.kingdee.com/article/474637295124176896?productLineId=3&isKnowledge=2&lang=zh-CN
    public static function itemStockUpdate($data){
        if(!isset($data['qty'])){
            $data['qty'] = 0;
        }
        $operate_result = false;

        if(isset($data['sku_id'])){
            $m = new StockLog();
            $re = $m->change(
                'in',
                config('addons.normstore.warehouse_code', ''),
                $data['sku_id'],
                $data['qty'],
                'cerp_bzxd',
                2
            );
            if($re['code'] < 10100){
                $operate_result = true;
            }
        }

        $data = [
            'operate_result' => $operate_result
        ];
        return recode(10000, $data);
    }

    //售后单下载接口（aftersale.order.query）
    //https://vip.kingdee.com/article/310065739652594944?productLineId=3&isKnowledge=2&lang=zh-CN
    public static function aftersaleOrderQuery($data){
        if(
            !isset($data['after_sale_id']) && 
            (!isset($data['start_time']) || !isset($data['end_time']))
        ){
            return recode(10100, '', '请求参数不正确');
        }
        $where = [];
        if(isset($data['after_sale_id'])){
            $where[] = ['a.aftersales_id', '=', $data['after_sale_id']];
        }else{
            $where[] = ['a.utime', '>=', $data['start_time']];
            $where[] = ['a.utime', '<', $data['end_time']];
        }

        if(isset($data['status'])){
            if($data['status'] == 'WAIT_SELLER_AGREE'){
                $where[] = ['a.status', '=', 1];
            }elseif($data['status'] == 'WAIT_BUYER_RETURN_GOODS'){
                $where[] = ['a.status', '=', 2];
                $where[] = ['rf.status', 'null'];
                $where[] = ['rs.status', 'null'];
            }elseif($data['status'] == 'WAIT_SELLER_CONFIRM_GOODS'){
                $where[] = ['a.status', '=', 2];
                $where[] = ['rf.status', 'null'];
                $where[] = ['rs.status', '=', 2];
            }elseif($data['status'] == 'SELLER_REFUSE_BUYER'){
                $where[] = ['a.status', '=', 3];
            }elseif($data['status'] == 'CLOSED'){       //没有这种场景
                $where[] = ['a.status', '=', 300];
            }elseif($data['status'] == 'SUCCESS'){
                $where[] = ['a.status', '=', 2];
                $where[] = ['rs.status', '=', 3];
                $where[] = ['rf.status', '=', 2];
            }
        }

        $limit = isset($data['page_size'])?$data['page_size']:20;
        $page = isset($data['page_no'])?$data['page_no']:1;

        $after_sale_list = [];

        $m = new Aftersales();
        $field = 'a.*,ai.order_items_id,ai.goods_id,ai.product_id,ai.pcode,ai.gcode,ai.name,ai.reship_nums,ai.refund_money,ai.point as ai_point,rf.status as rf_status,rs.status as rs_status,rs.logi_code, rs.logi_no';
        $list = $m
            ->alias('a')
            ->join((new AftersalesItems())->getTable().' ai', 'a.aftersales_id = ai.aftersales_id')
            ->leftJoin((new Refund())->getTable().' rf','rf.source_id = CONCAT(a.aftersales_id, "-", a.order_id)')
            ->leftJoin((new Reship())->getTable().' rs','rs.aftersales_id = a.aftersales_id')
            ->field($field)
            ->where($where)
            ->page($page, $limit)
            ->order('a.ctime asc, ai.id asc')->select();
        foreach($list as $v){
            //枚举
            //WAIT_SELLER_AGREE(买家已经申请退款，等待卖家同意) 
            //WAIT_BUYER_RETURN_GOODS(卖家已经同意退款，等待买家退货) 
            //WAIT_SELLER_CONFIRM_GOODS(买家已经退货，等待卖家确认收货) 
            //SELLER_REFUSE_BUYER(卖家拒绝退款) 
            //CLOSED(退款关闭) 
            //SUCCESS(退款成功)
            $status = '';
            if($v['status'] == 1){
                $status = 'WAIT_SELLER_AGREE';
            }elseif($v['status'] == 2){
                $status = 'WAIT_BUYER_RETURN_GOODS';
                //先判断退货
                if($v['rs_status'] == 2){
                    $status = 'WAIT_SELLER_CONFIRM_GOODS';
                }
                //如果已经申请通过，且退货成功，返回success
                if($v['rs_status'] == 3){
                    $status = 'SUCCESS';
                }
                //判断退款
                if($v['rf_status'] == 3){
                    $status = 'SUCCESS';
                }

            }else{
                $status = 'SELLER_REFUSE_BUYER';
            }

            $one = [
                'after_sale_id' => $v['aftersales_id'],
                'after_sale_type' => $v['type'],
                'tid' => $v['order_id'],
                'refund_fee' => $v['refund_money'],
                'oid' => $v['order_items_id'],
                'qty' => $v['reship_nums'],
                'created' => $v['ctime'],
                'modified' => $v['utime'],
                'status' => $status,
                'reason' => $v['reason'],
                'desc' => $v['mark']

            ];
            if($v['rs_status'] == 2){
                $one['company_name'] = config("shop.base.logistics.".$v['logi_code'].'.name', '其他');
                $one['sid'] = $v['logi_no'];
            }

            $after_sale_list[] = $one;

        }

        $data = [
            'after_sale_list' => $after_sale_list
        ];
        return recode(10000, $data);
    }

}