<?php
namespace addons\wxdelivery;	// 注意命名空间规范

use addons\wxdelivery\model\Order;
use app\common\Addons;

/**
 * 微信小程序发货信息录入插件
 */
class Addon extends Addons
{
    public $code = "wxdelivery";               //插件标识  必须与文件夹名完全一样
    public $name = "微信小程序发货信息录入插件";               //插件名称
    public $description = "小程序发货信息管理服务下的微信小程序发货信息录入接口对接";        //插件描述
    public $author = "SIN";             //作者
    public $version = "V1.0.0";            //版本
    public $relyon = [                  //依赖，安装此插件需要满足的条件，那些应用和插件必须先安装
        'app' => [],
        'addons' => []
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'install.sql';
        if(file_exists($file)){
            $sql = file_get_contents($file);
            $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
            $list = explode(';', $sql);
            for ($i = 0; $i < count($list); $i++) {
                if (trim($list[$i])) {
                    \think\facade\Db::execute(trim($list[$i]));
                }
            }
        }
        
        return recode(10000);
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        $file = root_path().'addons'. DIRECTORY_SEPARATOR . $this->code . DIRECTORY_SEPARATOR.'view'. DIRECTORY_SEPARATOR .'uninstall.sql';
        if(file_exists($file)){
            $sql = file_get_contents($file);
            $sql = str_replace("`jshop_", '`' . config('database.connections.mysql.prefix'), $sql);             //替换表前缀
            $list = explode(';', $sql);
            for ($i = 0; $i < count($list); $i++) {
                if (trim($list[$i])) {
                    \think\facade\Db::execute(trim($list[$i]));
                }
            }
        }
        return recode(10000);
    }

    /**
     * 应用初始化
     */
    public function init()
    {
        return recode(10000);
    }

    //订单发货成功事件
    public function b2cOrderUpdateShipStatus($data){
        if($data['ship_status'] == 3){
            $m = new Order();
            $m->toAdd($data['order_id']);
        }

        return true;
    }

    /**
     * 配置信息传到接口端
     */
    public function baseManageConfCommon($conf)
    {
        //物流模式，发货方式枚举值：1、实体物流配送采用快递公司进行实体物流配送形式 2、同城配送 3、虚拟商品，虚拟商品，例如话费充值，点卡等，无实体配送形式 4、用户自提
        $conf->addons['wxdelivery'] = [
            'logistics_type' => [
                1 => [
                    'name' => '物流配送',
                    'description' => '实体物流配送采用快递公司进行实体物流配送形式'
                ],
                2 => [
                    'name' => '同城配送',
                    'description' => '同城配送'
                ],
                3 => [
                    'name' => '无实体配送',
                    'description' => '虚拟商品，虚拟商品，例如话费充值，点卡等，无实体配送形式'
                ],
                4 => [
                    'name' => '用户自提',
                    'description' => '用户自提'
                ]
            ],
            'logs_status' => [
                1 => '待提交',
                2 => '请求中',
                3 => '成功',
                4 => '失败'
            ],  
            'order_status' => [
                1 => '待提交',
                2 => '成功',
                3 => '失败'
            ],  
        ];
    }


}