<?php
namespace addons\wxdelivery\controller\manage;

use addons\wxdelivery\model\Logs as ModelLogs;
use addons\wxdelivery\model\Order as ModelOrder;
use app\common\addons\controller\AddonsManageApi;

class Order extends AddonsManageApi
{
    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','show'=>true],
                ['label' => 'base.payment_id', 'prop' => 'payment_id', 'show'=>true],
                ['label' => 'wxdelivery.source_ids', 'prop' => 'source_ids', 'show'=>true],
                ['label' => 'status', 'prop' => 'status', 'show'=>true],
                ['label' => 'wxdelivery.order_remsg', 'prop' => 'remsg', 'show'=>true],
                ['label' => 'ctime', 'prop' => 'ctime', 'show'=>true],
                ['label' => 'utime', 'prop' => 'utime', 'show'=>true],
                ['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 列表
     */
    public function table()
    {
        $page = input('param.page/d', 1);
        $limit = input('param.limit/d', 10);
        $order = input('param.order/a', ['id' => 'desc']);
        $where = $this->tableWhere(input('param.filter/a',[]));
        $type = input('param.type/s','list');
    
        $m = new ModelLogs();
        $data = [];
        if($type == 'list'){
            $field = "*";
            $data['list'] = $m->field($field)->where($where)->page($page, $limit)->order($order)->select();
            
            if(input('?param.fields')){
                $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'wxdelivery-Order-table');
            }
        }elseif($type == 'count'){
            $data['count'] = $m->where($where)->count();
        }
        
        return recode(10000, $data);
    }

    //再次推送
    public function resend(){
        $rule = [
            'payment_id' => 'require',
        ];
        $message = [
            'payment_id' => ['payment_id','require'],
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        $m = new ModelOrder();

        return $m->toSend(input('param.payment_id'));
    }
    
    //补单
    public function toadd(){
        $rule = [
            'order_id' => 'require',
        ];
        $message = [
            'order_id' => ['order_id','require'],
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        $m = new ModelOrder();

        return $m->toAdd(input('param.order_id'));
    }

    

    /**
     * 账户的where条件整理
     */
    private function tableWhere($filter)
    {
        $where = [];
        if(isset($filter['id'])){
            $where[] = ['id', 'in', $filter['id']];
        }
        if(isset($filter['msg'])){
            $where[] = ['payment_id|source_ids|remsg', 'like', "%".$filter['msg']."%"];
        }
        if(isset($filter['status'])){
            $where[] = ['status', '=', $filter['status']];
        }
        if(isset($filter['ctime'][0])){
            $where[] = ['ctime', '>=', $filter['ctime'][0]];
        }
        if(isset($filter['ctime'][1])){
            $where[] = ['ctime', '<', $filter['ctime'][1]];
        }

        return $where;
    }
}