<?php
namespace addons\wxdelivery\controller\manage;

use addons\wxdelivery\model\Freight as ModelFreight;
use addons\wxdelivery\model\Logistics;
use app\b2c\model\Freight;
use app\common\addons\controller\AddonsManageApi;

class Setting extends AddonsManageApi
{
    const tableFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'id', 'prop' => 'id', 'minWidth' => '60','show'=>true],
                ['label' => 'wxdelivery.freight_name', 'prop' => 'name', 'show'=>true],
                ['label' => 'wxdelivery.logistics_code', 'prop' => 'logistics_type', 'show'=>true],
                ['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    const logiFields = [
        'order' => [],
        'fields' => [
            'default' => [
                ['label' => 'wxdelivery.logi_name', 'prop' => 'name', 'show'=>true],
                ['label' => 'wxdelivery.mycode', 'prop' => 'mycode', 'show'=>true],
                ['label' => 'wxdelivery.wxcode', 'prop' => 'wxcode', 'show'=>true],
                ['label' => 'actions', 'prop' => 'actions', 'minWidth' => '150','show'=>true],
            ],
        ]
    ];

    /**
     * 配送方式列表
     */
    public function freightTable()
    {
        $m = new Freight();
        $wxfModel = new ModelFreight();
        $data = [];
        $field = "id,name,sort,status";
        $data['list'] = $m->field($field)->select();
        
        foreach($data['list'] as &$v){
            $v['logistics_type'] = (string)($wxfModel->where('freight_name', $v['name'])->value('logistics_type'));
        }

        if(input('?param.fields')){
            $data['fields'] = $this->getFields(self::tableFields, input('param.fields/s'), 'wxdelivery-Setting-freightTable');
        }
        return recode(10000, $data);
        
        return recode(10000, $data);
    }

    public function freightSet(){
        $rule = [
            'freight_name' => 'require',
            'logistics_type' => 'require'
        ];
        $message = [
            'freight_name' => ['freight_name','require'],
            'logistics_type' => ['logistics_type', 'require']
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        $m = new ModelFreight();

        return $m->toAdd(input('param.freight_name/s'), input('param.logistics_type'));
    }

    /**
     * 物流列表
     */
    public function logiTable()
    {
        $m = new Logistics();
        $data = [];

        $list = config('shop.base.logistics');
        foreach($list as $k => $v){
            $data['list'][] = [
                'name' => $v['name'],
                'mycode' => $k,
                'wxcode' => (string)($m->where('mycode', $k)->value('wxcode'))
            ];
        }

        if(input('?param.fields')){
            $data['fields'] = $this->getFields(self::logiFields, input('param.fields/s'), 'wxdelivery-Setting-logiTable');
        }
        return recode(10000, $data);
        
        return recode(10000, $data);
    }

    public function logiSet(){
        $rule = [
            'mycode' => 'require',
            'wxcode' => 'require'
        ];
        $message = [
            'mycode' => ['mycode','require'],
            'wxcode' => ['wxcode', 'require']
        ];
        $re = $this->validate(input('param.'),$rule, $message);
        if($re['code'] >= 10100){
            return $re;
        }
        
        $m = new Logistics();

        return $m->toAdd(input('param.mycode/s'), input('param.wxcode/s'));
    }

}