<?php
namespace addons\wxdelivery\model;

use app\common\addons\AddonsModel;

/**
 *  物流模式对照表 
 *  物流模式，发货方式枚举值：1、实体物流配送采用快递公司进行实体物流配送形式 2、同城配送 3、虚拟商品，虚拟商品，例如话费充值，点卡等，无实体配送形式 4、用户自提
 */
class Freight extends AddonsModel
{
    /**
     * 添加&修改
     */
    public function toAdd($freight_name, $logistics_type)
    {
        $arr = [1,2,3,4];
        if(!in_array($logistics_type, $arr)){
            return recode(10100, '', '类型不正确');
        }

        $info = $this->where('freight_name', $freight_name)->find();
        if($info){
            $info->logistics_type = $logistics_type;
            $info->save();
        }else{
            $this->save([
                'freight_name' => $freight_name,
                'logistics_type' => $logistics_type
            ]);
        }

        return recode(10002);
    }


}