<?php
namespace addons\wxdelivery\model;

use app\common\addons\AddonsModel;

/**
 *  物流公司对照表 
 */
class Logistics extends AddonsModel
{
    /**
     * 添加&修改
     */
    public function toAdd($mycode, $wxcode)
    {
        if($mycode == "" || $wxcode == ""){
            return recode(10100, '', '不能为空');
        }

        $arr = config('shop.base.logistics');
        if(!isset($arr[$mycode])){
            return recode(10100, '', '物流公司不存在');
        }

        $info = $this->where('mycode', $mycode)->find();
        if($info){
            $info->wxcode = $wxcode;
            $info->save();
        }else{
            $this->save([
                'mycode' => $mycode,
                'wxcode' => $wxcode
            ]);
        }

        return recode(10002);
    }


}