<?php
namespace addons\wxdelivery\model;

use app\b2c\model\Delivery;
use app\b2c\model\DeliveryItems;
use app\b2c\model\Order as ModelOrder;
use app\base\lib\wx\app\AccessToken;
use app\base\model\Payments;
use app\common\addons\AddonsModel;
use app\common\lib\Curl;

class Order extends AddonsModel
{
    protected $autoWriteTimestamp = 'timestamp';
    protected $createTime = 'ctime';
    protected $updateTime = 'utime';


    /**
     * 添加， 根据订单号，取支付单号判断是否是微信小程序的支付单
     */
    public function toAdd($order_id)
    {   
        $pModel = new Payments();
        
        $where = [                                      //查询微信支付成功的订单类型的该订单的支付单，有个小缺陷是没区分出来微信小程序支付
            ['source_ids', 'find in set', $order_id],
            ['status', '=', 2],
            ['type', '=', 'order'],
            ['payment_code', '=', 'wechatpay'],
        ];
        $pinfo = $pModel->where($where)->find();
        if(!$pinfo){
            return recode(10100, '', '该订单没有找到对应的支付成功的微信支付单');
        }

        //判断是否加过，如果加过了，就不加了，如果没加过，就保存起来
        $info = $this->where('payment_id', $pinfo['payment_id'])->find();
        if($info){
            return recode(10100, '', '该支付单已经加过了，不允许重复添加');
        }

        $data = [
            'payment_id' => $pinfo['payment_id'], 
            'source_ids' => $pinfo['source_ids']
        ];
        $this->save($data);
        return recode(10001);
    }

    public function toSend($payment_id){
        $info = $this->where('payment_id', $payment_id)->where('status' , '<>', 2)->find();
        if(!$info){
            return recode(10100, '', '没找到记录不允许重复推送');
        }

        $pModel = new Payments();
        $pinfo = $pModel->where('payment_id', $payment_id)->find();
        $orders = explode(',', $pinfo['source_ids']);
        
        $dModel = new Delivery();
        $slist = [];
        $logistics_type = 0;

        foreach($orders as $order_id){
            //取配送方式,根据第一个订单里的配送方式来取
            if($logistics_type === 0){
                $re_ltype = $this->getWxFreight($order_id);
                if($re_ltype['code'] >= 10100){

                    $info->status = 3;
                    $info->remsg = $re_ltype['msg'];
                    $info->save();

                    return $re_ltype;
                }
                $logistics_type = $re_ltype['data'];
            }

            $dlist = $dModel->where('order_ids', 'find in set', $order_id)->select();
            foreach($dlist as $v){
                if(isset($slist[$v['delivery_id']])){
                    continue;           //极端情况下，多个订单在同一个发货单中，那么就存1个发货单即可。
                }
                //物流公司编码
                $expressCode = $this->getWxExpressCode($v['logi_code']);
                if(!$expressCode){
                    $info->status = 3;
                    $info->remsg = "物流公司编码：".$v['logi_code']."没有维护";
                    $info->save();

                    return recode(10100, '', "物流公司编码：".$v['logi_code']."没有维护");
                }
                $slist[$v['delivery_id']] = [
                    'tracking_no' => $v['logi_no'],                        //物流单号
                    'express_company' => $expressCode,                    //物流公司编码  SF
                    'item_desc' => $this->getDeliveryItemsName($v['delivery_id']),                      //订单明细
                    'contact' => [
                        'receiver_contact' => substr($v['ship_mobile'], 0, 3) . "****" . substr($v['ship_mobile'], 7)                //收货人信息
                    ]
                ];
            }
        }

        if(count($slist) <= 0){
            $info->status = 3;
            $info->remsg = '没有找到发货单';
            $info->save();

            return recode(10100, '', '没有找到发货单');
        }

        $senddata = [
            'order_key' => [
                'order_number_type' => 1,
                'out_trade_no' => $payment_id,
                'mchid' => config('shop.base.payments.code.wechatpay.config.mch_id', '')
            ],
            'logistics_type' => $logistics_type,
            'upload_time' => date('Y-m-d\TH:i:s.120+08:00', time()),             //上传时间
            'payer' => [
                'openid' => $this->getWxOpenid($pinfo)                  //小程序openid
            ]
        ];
        if(count($slist) == 1){
            $senddata['delivery_mode'] = 1;
        }else{
            $senddata['delivery_mode'] = 2;
            $senddata['is_all_delivered'] = true;
        }
        $senddata['shipping_list'] = array_values($slist);

        //去请求
        $re = $this->toCurl($senddata);
        if($re['code'] < 10100){
            $info->status = 2;
            $info->remsg = $re['msg'];
        }else{
            $info->status = 3;
            $info->remsg = $re['msg'];
        }
        $info->save();

        return $re;
    }

    private function toCurl($data){
        $log = new Logs();
        $log->save([
            'payment_id' => $data['order_key']['out_trade_no'],
            'senddata' => json_encode($data,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE),
            'redata' => '',
            'status' => 2,
        ]);

        //获取微信小程序accesstoken
        $re_token = AccessToken::getAccessToken();
        if($re_token['code'] >= 10100){
            $log->redata = json_encode($re_token, JSON_UNESCAPED_UNICODE);
            $log->status = 4;
            $log->save();
            return $re_token;
        }

        $url = "https://api.weixin.qq.com/wxa/sec/order/upload_shipping_info?access_token=". $re_token['data'];

        $re = Curl::post($url, $log->senddata);

        //$re = '{"errcode":0,"errmsg":"ok"}';
        //$re = '{"errcode":10060031,"errmsg":"该笔支付单不属于 openid 所指定的用户 rid: 663dff78-79fd8250-7475f3f7"}';
        $log->redata = $re;

        $re = json_decode($re, true);

        if($re['errcode'] == 0){
            $log->status = 3;
            $result = recode(10000);
        }else{
            $log->status = 4;
            $result = recode(10100, '', isset($re['errmsg'])?$re['errmsg']:'出错了');
        }
        $log->save();

        return $result;

    }

    //获取发货单明细商品
    private function getDeliveryItemsName($delivery_id){
        $m = new DeliveryItems();
        $list = $m->where('delivery_id', $delivery_id)->select();
        $name = "";
        foreach($list as $v){
            $name .= $v['name']." ";
        }
        return $name;
    }

    //根据订单号获取微信的配送方式
    private function getWxFreight($order_id){
        $omodel = new ModelOrder();
        $oinfo = $omodel->where('order_id', $order_id)->find();
        if(!$oinfo){
            return recode(10100, '', '订单号：'.$order_id."没有找到");
        }

        $wxfModel = new Freight();
        $wxfInfo = $wxfModel->where('freight_name', $oinfo['freight_name'])->cache(3600)->find();
        if(!$wxfInfo){
            return recode(10100, '', '配送方式：'. $oinfo['freight_name'].' 没有找到，请先配置配送方式');
        }
        return recode(10000, $wxfInfo['logistics_type']);

    }

    //根据系统内部物流公司编码转换微信物流公司编码
    private function getWxExpressCode($logi_code){
        $m = new Logistics();
        $info = $m->where('mycode', $logi_code)->find();
        if($info){
            return $info['wxcode'];
        }
        return false;
    }


    //获取openid
    private function getWxOpenid($pinfo){
        $params = json_decode($pinfo['params'], true);
        if(isset($params['openid'])){
            return $params['openid'];
        }

        return "";
    }


}